/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.mixin.checker;

import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import top.hendrixshen.magiclib.api.dependency.DependencyCheckException;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.api.mixin.checker.MixinDependencyCheckFailureCallback;
import top.hendrixshen.magiclib.api.mixin.checker.MixinDependencyChecker;
import top.hendrixshen.magiclib.impl.dependency.DependenciesContainer;
import top.hendrixshen.magiclib.util.DependencyUtil;
import top.hendrixshen.magiclib.util.MiscUtil;
import top.hendrixshen.magiclib.util.collect.InfoNode;
import top.hendrixshen.magiclib.util.mixin.MixinUtil;

public class SimpleMixinChecker
implements MixinDependencyChecker {
    private MixinDependencyCheckFailureCallback failureCallback;

    @Override
    public boolean check(String targetClassName, String mixinClassName) {
        ClassNode targetClassNode = MixinUtil.getClassNode(targetClassName);
        ClassNode mixinClassNode = MixinUtil.getClassNode(mixinClassName);
        if (mixinClassNode == null) {
            return false;
        }
        List nodes = DependencyUtil.parseDependencies(mixinClassNode, targetClassNode);
        if (nodes.isEmpty()) {
            return true;
        }
        if (nodes.stream().anyMatch(DependenciesContainer::isSatisfied)) {
            return true;
        }
        InfoNode rootNode = new InfoNode(null, I18n.tr("magiclib.dependency.checker.mixin.title", mixinClassName, targetClassName));
        MiscUtil.generateDependencyCheckMessage(nodes, rootNode);
        this.onCheckFailure(targetClassName, mixinClassName, new DependencyCheckException(rootNode.toString()));
        return false;
    }

    @Override
    public void setCheckFailureCallback(MixinDependencyCheckFailureCallback callback) {
        this.failureCallback = callback;
    }

    private void onCheckFailure(String targetClassName, String mixinClassName, DependencyCheckException result) {
        if (this.failureCallback != null) {
            this.failureCallback.callback(targetClassName, mixinClassName, result);
        }
    }
}

