/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.platform;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.platform.Platform;

public final class PlatformManager {
    private final MagicLib magicLib;
    private Platform currentPlatform;
    private final AtomicBoolean initialized = new AtomicBoolean();

    public PlatformManager(MagicLib magicLib) {
        Preconditions.checkNotNull((Object)magicLib);
        this.magicLib = magicLib;
    }

    public void register(Platform platform) {
        Preconditions.checkNotNull((Object)platform);
        this.currentPlatform = platform;
        this.initialized.set(true);
    }

    public void unregister() {
        this.currentPlatform = null;
        this.initialized.set(false);
    }

    public Platform getCurrentPlatform() {
        if (this.initialized()) {
            return this.currentPlatform;
        }
        throw new IllegalStateException("Platform is not present!");
    }

    public boolean initialized() {
        return this.initialized.get();
    }

    @Generated
    public MagicLib getMagicLib() {
        return this.magicLib;
    }
}

