/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.i18n.provider;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.i18n.LanguageProvider;
import top.hendrixshen.magiclib.util.JsonUtil;

public class JarLanguageProvider
implements LanguageProvider {
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Map<String, Map<String, String>> languageMap = Maps.newConcurrentMap();

    @Override
    public void init() {
        try {
            for (URL resource : Collections.list(this.getClass().getClassLoader().getResources("assets"))) {
                if (!resource.getProtocol().equals("jar")) continue;
                JarURLConnection connection = (JarURLConnection)resource.openConnection();
                this.loadFromJar(connection.getJarFile());
            }
        }
        catch (IOException e) {
            MagicLib.getLogger().error("Failed to load language file.", (Throwable)e);
        }
    }

    @Override
    public void reload() {
    }

    @Override
    public void reload(String LanguageCode) {
    }

    @Override
    public void loadLanguage(String languageCode) {
    }

    @Override
    public Map<String, String> getLanguage(@NotNull String languageCode) {
        return this.languageMap.computeIfAbsent(languageCode.toLowerCase(), key -> Maps.newConcurrentMap());
    }

    private void loadFromJar(@NotNull JarFile jar) {
        for (ZipEntry zipEntry : Collections.list(jar.entries())) {
            try {
                InputStream inputStream = jar.getInputStream(zipEntry);
                try {
                    if (!JarLanguageProvider.loadFromEntry(zipEntry, inputStream, this::getLanguage)) continue;
                    MagicLib.getLogger().debug("Loaded language file {} from {}.", (Object)zipEntry.getName(), (Object)jar.getName());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                MagicLib.getLogger().error("Failed to load language file {} from {}.", (Object)zipEntry.getName(), (Object)jar.getName(), (Object)e);
            }
        }
    }

    @ApiStatus.Internal
    public static boolean loadFromEntry(@NotNull ZipEntry entry, InputStream inputStream, Function<String, Map<String, String>> languageMapGetter) {
        Matcher matcher = LanguageProvider.LANGUAGE_PATH_PATTERN.matcher(entry.getName());
        if (!matcher.find()) {
            return false;
        }
        Map<String, String> language = languageMapGetter.apply(matcher.group(2));
        JsonUtil.loadLanguageMapFromJson(inputStream, language::put);
        return true;
    }

    @Generated
    private JarLanguageProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static JarLanguageProvider getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    JarLanguageProvider actualValue = new JarLanguageProvider();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (JarLanguageProvider)($value == instance ? null : $value);
    }
}

