/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class SystemUtil {
    private static final List<Option> PROPERTIES = Lists.newArrayList();

    @NotNull
    public static @Unmodifiable Collection<Option> getProperties() {
        return ImmutableList.copyOf(PROPERTIES);
    }

    public static final class Option {
        private final Option parent;
        private final InheritType inheritType;
        private final String property;
        private final String defaultValue;
        private final boolean isFlag;
        private final int depth;

        @NotNull
        public static Option newOption(String property) {
            return Option.newOption(null, property, true);
        }

        @NotNull
        public static Option newOption(InheritType inheritType, String property) {
            return Option.newOption(null, inheritType, property, true);
        }

        @NotNull
        public static Option newOption(String property, boolean flag) {
            return Option.newOption(null, property, flag);
        }

        @NotNull
        public static Option newOption(String property, String defaultStringValue) {
            return new Option(null, InheritType.INDEPENDENT, property, false, defaultStringValue);
        }

        @NotNull
        public static Option newOption(Option parent, String property) {
            return Option.newOption(parent, InheritType.INHERIT, property, true);
        }

        @NotNull
        public static Option newOption(Option parent, InheritType inheritType, String property) {
            return Option.newOption(parent, inheritType, property, true);
        }

        @NotNull
        public static Option newOption(Option parent, String property, boolean isFlag) {
            return new Option(parent, InheritType.INHERIT, property, isFlag, null);
        }

        @NotNull
        public static Option newOption(Option parent, InheritType inheritType, String property, boolean isFlag) {
            return new Option(parent, inheritType, property, isFlag, null);
        }

        @NotNull
        public static Option newOption(Option parent, String property, String defaultStringValue) {
            return new Option(parent, InheritType.INHERIT, property, false, defaultStringValue);
        }

        @NotNull
        public static Option newOption(Option parent, InheritType inheritType, String property, String defaultStringValue) {
            return new Option(parent, inheritType, property, false, defaultStringValue);
        }

        private Option(Option parent, InheritType inheritance, String property, boolean isFlag, String defaultStringValue) {
            this.parent = parent;
            this.inheritType = inheritance;
            this.property = (parent != null ? parent.property + "." : "") + property;
            this.defaultValue = defaultStringValue;
            this.isFlag = isFlag;
            int depth = 0;
            while (parent != null) {
                parent = parent.parent;
                ++depth;
            }
            this.depth = depth;
            PROPERTIES.add(this);
        }

        public String toString() {
            return this.isFlag ? String.valueOf(this.getBooleanValue()) : this.getStringValue();
        }

        public boolean getLocalBooleanValue(boolean defaultValue) {
            return Boolean.parseBoolean(System.getProperty(this.property, Boolean.toString(defaultValue)));
        }

        public boolean getInheritedBooleanValue() {
            return this.parent != null && this.parent.getBooleanValue();
        }

        public boolean getBooleanValue() {
            if (this.inheritType == InheritType.ALWAYS_FALSE) {
                return false;
            }
            boolean local = this.getLocalBooleanValue(false);
            if (this.inheritType == InheritType.INDEPENDENT) {
                return local;
            }
            boolean inherited = local || this.getInheritedBooleanValue();
            return this.inheritType == InheritType.INHERIT ? inherited : this.getLocalBooleanValue(inherited);
        }

        public String getStringValue() {
            return this.inheritType == InheritType.INDEPENDENT || this.parent == null || this.parent.getBooleanValue() ? System.getProperty(this.property, this.defaultValue) : this.defaultValue;
        }

        public <E extends Enum<E>> E getEnumValue(@NotNull E defaultValue) {
            String value = System.getProperty(this.property, defaultValue.name());
            try {
                Object e = Enum.valueOf(defaultValue.getClass(), value.toUpperCase(Locale.ROOT));
                return (E)e;
            }
            catch (IllegalArgumentException ex) {
                return defaultValue;
            }
        }

        @Generated
        public Option getParent() {
            return this.parent;
        }

        @Generated
        public String getProperty() {
            return this.property;
        }

        @Generated
        public int getDepth() {
            return this.depth;
        }

        public static enum InheritType {
            INHERIT,
            ALLOW_OVERRIDE,
            INDEPENDENT,
            ALWAYS_FALSE;

        }
    }
}

