/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.mixin.minecraft.event.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.hendrixshen.magiclib.impl.event.EventManager;
import top.hendrixshen.magiclib.impl.event.minecraft.render.RenderEntityEvent;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin {
    @Unique
    private Entity magiclib$entity;
    @Unique
    private float magiclib$tickDelta;

    @Inject(method={"render(Lnet/minecraft/client/renderer/entity/state/EntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")})
    private void preRenderEntity(EntityRenderState entityRenderState, PoseStack poseStack, MultiBufferSource source, int light, CallbackInfo ci) {
        EventManager.dispatch(new RenderEntityEvent.PreRender(RenderEntityEvent.EntityRenderContext.of(this.magiclib$entity, poseStack, this.magiclib$tickDelta)));
    }

    @Inject(method={"render(Lnet/minecraft/client/renderer/entity/state/EntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="RETURN")})
    private void postRenderEntity(EntityRenderState entityRenderState, PoseStack poseStack, MultiBufferSource source, int light, CallbackInfo ci) {
        EventManager.dispatch(new RenderEntityEvent.PostRender(RenderEntityEvent.EntityRenderContext.of(this.magiclib$entity, poseStack, this.magiclib$tickDelta)));
    }

    @Inject(method={"createRenderState(Lnet/minecraft/world/entity/Entity;F)Lnet/minecraft/client/renderer/entity/state/EntityRenderState;"}, at={@At(value="HEAD")})
    private void recordSharedVar(Entity entity, float tickDelta, CallbackInfoReturnable<EntityRenderState> cir) {
        this.magiclib$entity = entity;
        this.magiclib$tickDelta = tickDelta;
    }
}

