/*
 * Decompiled with CFR 0.152.
 */
package net.dyrohc.diminishinghealth;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="diminishing_health", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigFile {
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ConfigFile.apply();
        }
    }

    @SubscribeEvent
    public static void onReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ConfigFile.apply();
        }
    }

    public static void apply() {
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        SERVER = new Server(builder);
        SERVER_CONFIG = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG, "Diminishing_Health.toml");
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue CFG_toggle_partial;
        public final ForgeConfigSpec.BooleanValue CFG_toggle_full;
        public final ForgeConfigSpec.BooleanValue CFG_toggle_passive;
        public final ForgeConfigSpec.BooleanValue CFG_toggle_sleep;
        public final ForgeConfigSpec.BooleanValue CFG_toggle_determination;
        public final ForgeConfigSpec.BooleanValue CFG_timer_reset;
        public final ForgeConfigSpec.BooleanValue CFG_determination_cooldown_deaths;
        public final ForgeConfigSpec.BooleanValue CFG_craving_compat_toggle;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_partial_recovery_items;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_full_recovery_items;
        public final ForgeConfigSpec.IntValue CFG_original_max_health;
        public final ForgeConfigSpec.IntValue CFG_healing_timer;
        public final ForgeConfigSpec.IntValue CFG_deaths_for_determination;
        public final ForgeConfigSpec.IntValue CFG_determination_set_cooldown;
        public final ForgeConfigSpec.IntValue CFG_health_loss;
        public final ForgeConfigSpec.IntValue CFG_partial_recovered;
        public final ForgeConfigSpec.IntValue CFG_passive_recovered;
        public final ForgeConfigSpec.IntValue CFG_sleep_recovered;
        public final ForgeConfigSpec.IntValue CFG_determination_recovered;
        public final ForgeConfigSpec.IntValue CFG_craving_recovered;
        public final ForgeConfigSpec.BooleanValue CFG_grace_sleep_toggle;
        public final ForgeConfigSpec.IntValue CFG_grace_sleep_duration;
        public final ForgeConfigSpec.BooleanValue CFG_grace_firstdeath_toggle;
        public final ForgeConfigSpec.IntValue CFG_grace_firstdeath_duration;
        public final ForgeConfigSpec.BooleanValue CFG_grace_determination_toggle;
        public final ForgeConfigSpec.IntValue CFG_grace_determination_duration;
        public final ForgeConfigSpec.IntValue CFG_hardmode_threshold;
        public final ForgeConfigSpec.DoubleValue CFG_threshold_decay;
        public final ForgeConfigSpec.IntValue CFG_threshold_decay_interval;
        public final ForgeConfigSpec.BooleanValue CFG_decay_reset;
        public final ForgeConfigSpec.IntValue CFG_hardmode_loss;
        public final ForgeConfigSpec.BooleanValue CFG_true_damage;
        public final ForgeConfigSpec.BooleanValue CFG_old_hardmode;
        public final ForgeConfigSpec.IntValue CFG_hardmode_chance;
        public final ForgeConfigSpec.BooleanValue CFG_modernfix_warning;

        Server(ForgeConfigSpec.Builder builder) {
            builder.push("Main Toggles");
            this.CFG_toggle_partial = builder.comment("Allows partial health recovery by eating partial health recovery items. (Default: true)").define("Toggle Partial Health Recovery", true);
            this.CFG_toggle_full = builder.comment("Allows full health recovery by eating full health recovery items. (Default: true)").define("Toggle Full Health Recovery", true);
            this.CFG_toggle_passive = builder.comment("Allows passive health recovery every full Minecraft day. (Default: true)").define("Toggle Passive Health Recovery", true);
            this.CFG_toggle_sleep = builder.comment("Allows health recovery when sleeping through the night. (Default: true)").define("Toggle Sleep Health Recovery", true);
            this.CFG_toggle_determination = builder.comment("Enables recovery mechanic after multiple consecutive deaths at 1 HP with a cooldown. (Default: true)").define("Toggle Determination", true);
            builder.pop();
            builder.push("Minor Toggles");
            this.CFG_timer_reset = builder.comment("Should the passive recovery timer reset when you die. (Default: true)").define("Reset Passive Recovery on Death", true);
            this.CFG_determination_cooldown_deaths = builder.comment("Should deaths count toward determination even while it is on cooldown. (Default: true)").define("Deaths Count While Determination is on Cooldown", true);
            this.CFG_craving_compat_toggle = builder.comment("Toggle whether satisfying a craving restores some of your health if mod Cravings! is installed. (Default: true)").define("Cravings! compatibility toggle", true);
            builder.pop();
            builder.push("Health Recovery Items");
            this.CFG_partial_recovery_items = builder.comment("Items that, when consumed, partially restore your original max health.").defineListAllowEmpty("Partial Health Recovery Items", List.of("minecraft:golden_apple"), obj -> obj instanceof String);
            this.CFG_full_recovery_items = builder.comment("Items that, when consumed, fully restore your original max health.").defineListAllowEmpty("Full Health Recovery Items", List.of("minecraft:enchanted_golden_apple"), obj -> obj instanceof String);
            builder.pop();
            builder.push("Max Health");
            this.CFG_original_max_health = builder.comment("Your original max health. Used to calculate loss, recovery, and cap (default: 20).").comment("Use to gain extra hearts. Not compatible (yet) with mods that alter health.").defineInRange("Max Default Health", 20, 1, 512);
            builder.pop();
            builder.push("Timers and Cooldowns");
            this.CFG_healing_timer = builder.comment("Time in ticks before passive recovery triggers again. (Default: 24000 = 1 full Minecraft day)").defineInRange("Time Between Recoveries", 24000, 0, Integer.MAX_VALUE);
            this.CFG_deaths_for_determination = builder.comment("Number of consecutive deaths at 1 health before Determination activates. (Default: 3)").defineInRange("Deaths for Determination", 3, 1, Integer.MAX_VALUE);
            this.CFG_determination_set_cooldown = builder.comment("Cooldown time in ticks before Determination can trigger again. (Default: 12000 = half a day)").defineInRange("Determination Cooldown", 12000, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Health loss and recovery percentages");
            this.CFG_health_loss = builder.comment("Percentage of your current max health lost on death. Set to 0 to disable. (Default: 50)").defineInRange("Health Lost on Death", 50, 0, 100);
            this.CFG_partial_recovered = builder.comment("Percentage of your max health restored when using partial recovery items. (Default: 25)").defineInRange("Partial Health Recovered", 25, 1, 100);
            this.CFG_passive_recovered = builder.comment("Percentage of your max health restored after surviving a full Minecraft day. (Default: 5)").defineInRange("Passive Health Recovered", 15, 1, 100);
            this.CFG_sleep_recovered = builder.comment("Percentage of your max health restored by sleeping. (Default: 5)").defineInRange("Sleep Health Recovered", 5, 1, 100);
            this.CFG_determination_recovered = builder.comment("Percentage of your max health restored via Determination. (Default: 15)").defineInRange("Determination Health Recovered", 15, 1, 100);
            this.CFG_craving_recovered = builder.comment("Percentage of your max health restored by satisfying a craving if the mod Cravings! is installed. (Default: 5)").defineInRange("Craving Satisfied Health Recovered", 5, 1, 100);
            builder.pop();
            builder.push("Grace settings");
            this.CFG_grace_sleep_toggle = builder.comment("Determines whether sleeping grants the player the Grace effect upon waking.").comment("This effect protects them from losing max health on their next death. (default: true").define("Sleep Grace Toggle", true);
            this.CFG_grace_sleep_duration = builder.comment("Sets how long the Grace effect from sleeping will last, in ticks. (Default: 2400)").defineInRange("Sleep Grace Duration", 2400, 0, Integer.MAX_VALUE);
            this.CFG_grace_firstdeath_toggle = builder.comment("Determines whether the player receives the Grace effect after their first death from full health. (default: true)").define("Grace on First Death Toggle", true);
            this.CFG_grace_firstdeath_duration = builder.comment("Sets how long the Grace effect from dying on full health will last, in ticks. (Default: 6000)").defineInRange("Grace on First Death Duration", 6000, 0, Integer.MAX_VALUE);
            this.CFG_grace_determination_toggle = builder.comment("Determines whether triggering Determination also grants the Grace effect. (Default: true").define("Grace from Determination", true);
            this.CFG_grace_determination_duration = builder.comment("Sets how long the Grace effect from Determination will last, in ticks. (Default: 2400)").defineInRange("Grace from Determination Duration", 2400, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Hardmode settings");
            this.CFG_hardmode_threshold = builder.comment("The amount of damage that must be acumulated to lose health. (default: 10)").defineInRange("HardMode Threshold", 10, 1, Integer.MAX_VALUE);
            this.CFG_threshold_decay = builder.comment("The amount of damage the threshold will be reduced by every second. (default: 0.5)").defineInRange("Threshold Decay", 0.5, 0.0, 100.0);
            this.CFG_threshold_decay_interval = builder.comment("The time interval (in ticks) between each reduction of accumulated damage.").comment("Set to very big if you don't want any decay.").comment("20 ticks = 1 second. (Default: 40)").defineInRange("Threshold Decay Interval", 40, 1, Integer.MAX_VALUE);
            this.CFG_decay_reset = builder.comment("If enabled, the timer that reduces accumulated damage will reset each time the player takes damage. (Default: true)").define("Threshold Decay Reset", true);
            this.CFG_hardmode_loss = builder.comment("Percentage of max health lost per hit when Hardmode is active. (Default: 10)").defineInRange("Hardmode Health Loss", 10, 1, 100);
            this.CFG_true_damage = builder.comment("When enabled, all damage added to the HardMode threshold ignores armor, resistance, and other reductions.").comment("While this makes HardMode more punishing, it also ensures damage tracking is more consistent and stable. (Default: false)").define("True Damage", false);
            this.CFG_old_hardmode = builder.comment("Disable the new threshold system to use a chance-based HardMode, where there is a chance you lose health everytime you receive a hit. (default: false)").define("Old HardMode", false);
            this.CFG_hardmode_chance = builder.comment("Chance to lose max health when damaged while Hardmode is active. (Default: 100)").comment("This does not need to be lowered to earn the 'Dumb Luck' achievement.").defineInRange("Hardmode Chance", 100, 0, 100);
            builder.pop();
            builder.push("Miscellaneous configs");
            this.CFG_modernfix_warning = builder.comment("Show a warning on world load if ModernFix is installed.").comment("This mod normally updates config values during gameplay, but ModernFix prevents this.").comment("If you are using ModernFix and change any config values, a full game restart will be required.").comment("The mod will still work as intended with ModernFix installed.").define("Show ModernFix warning", true);
            builder.pop();
        }
    }
}

