/*
 * Decompiled with CFR 0.152.
 */
package net.dyrohc.diminishinghealth;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="diminishing_health", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigFileClient {
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            ConfigFileClient.apply();
        }
    }

    @SubscribeEvent
    public static void onReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            ConfigFileClient.apply();
        }
    }

    public static void apply() {
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        CLIENT = new Client(builder);
        CLIENT_CONFIG = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG, "Diminishing_Health-Client.toml");
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue CFG_bbody_effect_toggle;
        public final ForgeConfigSpec.BooleanValue CFG_hardmode_visual;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("UI Settings");
            this.CFG_bbody_effect_toggle = builder.comment("Shows a permanent dummy status effect whenever your maximum health has been reduced but not yet restored. (Default: true)").define("Broken Body Effect", true);
            this.CFG_hardmode_visual = builder.comment("Displays a special golden heart icon that gradually fills as you approach the HardMode damage threshold. (Default: true)").define("HardMode Threshold Indicator", true);
            builder.pop();
        }
    }
}

