/*
 * Decompiled with CFR 0.152.
 */
package net.dyrohc.diminishinghealth.network;

import java.util.function.Supplier;
import net.dyrohc.diminishinghealth.DiminishingHealthMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DiminishingHealthModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        DiminishingHealthMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handleData);
        DiminishingHealthMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int dataType;
        private final SavedData data;

        public SavedDataSyncMessage(int dataType, SavedData data) {
            this.dataType = dataType;
            this.data = data;
        }

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt);
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt);
                }
            }
            this.dataType = dataType;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handleData(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.m_7176_(new CompoundTag()));
                    } else {
                        WorldVariables.clientSide.read(message.data.m_7176_(new CompoundTag()));
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) {
        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this(new PlayerVariables());
            this.data.deserializeNBT(buffer.m_130260_());
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_(message.data().serializeNBT());
        }

        public static void handleData(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES).ifPresent(cap -> cap.deserializeNBT(message.data.serializeNBT()));
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        boolean _syncDirty = false;
        public double currentMaxHealth = 20.0;
        public double RecoveryDayTicks = 0.0;
        public double one_health_deaths = 0.0;
        public boolean determination_on_cooldown = false;
        public double determination_cooldown_duration = 0.0;
        public double determination_uses = 0.0;
        public double health_halved_times = 0.0;
        public double full_recovery_times = 0.0;
        public double partial_recovery_times = 0.0;
        public String usedItemID = "\"\"";
        public double reapply_timer = 0.0;
        public boolean bb_effect_toggle = false;
        public boolean hardmode_visual = false;
        public double threshold_current = 0.0;
        public double Threshold_timer = 0.0;
        public double player_health = 0.0;
        public boolean pending_health_update = false;
        public double reaper_timer = 0.0;
        public double Hitless_timer = 0.0;
        public boolean graced = false;
        public boolean grace_on_respawn = false;

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("currentMaxHealth", this.currentMaxHealth);
            nbt.m_128347_("RecoveryDayTicks", this.RecoveryDayTicks);
            nbt.m_128347_("one_health_deaths", this.one_health_deaths);
            nbt.m_128379_("determination_on_cooldown", this.determination_on_cooldown);
            nbt.m_128347_("determination_cooldown_duration", this.determination_cooldown_duration);
            nbt.m_128347_("determination_uses", this.determination_uses);
            nbt.m_128347_("health_halved_times", this.health_halved_times);
            nbt.m_128347_("full_recovery_times", this.full_recovery_times);
            nbt.m_128347_("partial_recovery_times", this.partial_recovery_times);
            nbt.m_128359_("usedItemID", this.usedItemID);
            nbt.m_128347_("reapply_timer", this.reapply_timer);
            nbt.m_128379_("bb_effect_toggle", this.bb_effect_toggle);
            nbt.m_128379_("hardmode_visual", this.hardmode_visual);
            nbt.m_128347_("threshold_current", this.threshold_current);
            nbt.m_128347_("Threshold_timer", this.Threshold_timer);
            nbt.m_128347_("player_health", this.player_health);
            nbt.m_128379_("pending_health_update", this.pending_health_update);
            nbt.m_128347_("reaper_timer", this.reaper_timer);
            nbt.m_128347_("Hitless_timer", this.Hitless_timer);
            nbt.m_128379_("graced", this.graced);
            nbt.m_128379_("grace_on_respawn", this.grace_on_respawn);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.currentMaxHealth = nbt.m_128459_("currentMaxHealth");
            this.RecoveryDayTicks = nbt.m_128459_("RecoveryDayTicks");
            this.one_health_deaths = nbt.m_128459_("one_health_deaths");
            this.determination_on_cooldown = nbt.m_128471_("determination_on_cooldown");
            this.determination_cooldown_duration = nbt.m_128459_("determination_cooldown_duration");
            this.determination_uses = nbt.m_128459_("determination_uses");
            this.health_halved_times = nbt.m_128459_("health_halved_times");
            this.full_recovery_times = nbt.m_128459_("full_recovery_times");
            this.partial_recovery_times = nbt.m_128459_("partial_recovery_times");
            this.usedItemID = nbt.m_128461_("usedItemID");
            this.reapply_timer = nbt.m_128459_("reapply_timer");
            this.bb_effect_toggle = nbt.m_128471_("bb_effect_toggle");
            this.hardmode_visual = nbt.m_128471_("hardmode_visual");
            this.threshold_current = nbt.m_128459_("threshold_current");
            this.Threshold_timer = nbt.m_128459_("Threshold_timer");
            this.player_health = nbt.m_128459_("player_health");
            this.pending_health_update = nbt.m_128471_("pending_health_update");
            this.reaper_timer = nbt.m_128459_("reaper_timer");
            this.Hitless_timer = nbt.m_128459_("Hitless_timer");
            this.graced = nbt.m_128471_("graced");
            this.grace_on_respawn = nbt.m_128471_("grace_on_respawn");
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"diminishing_health", (String)"player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES ? this.instance.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.playerVariables.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.playerVariables.deserializeNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "diminishing_health_mapvars";
        boolean _syncDirty = false;
        public boolean toggle_partial = true;
        public boolean toggle_full = true;
        public boolean toggle_passive = true;
        public boolean toggle_sleep = true;
        public boolean toggle_determination = true;
        public boolean timer_reset = true;
        public boolean determination_cooldown_deaths = true;
        public double original_max_health = 20.0;
        public double healing_timer = 24000.0;
        public double deaths_for_determination = 3.0;
        public double determination_set_cooldown = 12000.0;
        public double health_loss = 50.0;
        public double partial_recovered = 25.0;
        public double passive_recovered = 15.0;
        public double sleep_recovered = 0.0;
        public double determination_recovered = 15.0;
        public double hardmode_chance = 100.0;
        public double hardmode_loss = 5.0;
        public boolean modernfix_warning = false;
        public boolean HardmodeOn = false;
        public double hardmode_threshold = 0.0;
        public boolean old_hardmode = false;
        public double threshold_decay_interval = 0.0;
        public double threshold_decay = 0.0;
        public boolean decay_reset = false;
        public double heart_25 = 0.0;
        public double heart_50 = 0.0;
        public double heart_75 = 0.0;
        public boolean true_damage = false;
        public boolean craving_compat_toggle = true;
        public double craving_recovered = 15.0;
        public boolean grace_sleep_toggle = true;
        public boolean grace_firstdeath_toggle = true;
        public boolean grace_determination_toggle = true;
        public double grace_sleep_duration = 2400.0;
        public double grace_firstdeath_duration = 6000.0;
        public double grace_determination_duration = 2400.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.toggle_partial = nbt.m_128471_("toggle_partial");
            this.toggle_full = nbt.m_128471_("toggle_full");
            this.toggle_passive = nbt.m_128471_("toggle_passive");
            this.toggle_sleep = nbt.m_128471_("toggle_sleep");
            this.toggle_determination = nbt.m_128471_("toggle_determination");
            this.timer_reset = nbt.m_128471_("timer_reset");
            this.determination_cooldown_deaths = nbt.m_128471_("determination_cooldown_deaths");
            this.original_max_health = nbt.m_128459_("original_max_health");
            this.healing_timer = nbt.m_128459_("healing_timer");
            this.deaths_for_determination = nbt.m_128459_("deaths_for_determination");
            this.determination_set_cooldown = nbt.m_128459_("determination_set_cooldown");
            this.health_loss = nbt.m_128459_("health_loss");
            this.partial_recovered = nbt.m_128459_("partial_recovered");
            this.passive_recovered = nbt.m_128459_("passive_recovered");
            this.sleep_recovered = nbt.m_128459_("sleep_recovered");
            this.determination_recovered = nbt.m_128459_("determination_recovered");
            this.hardmode_chance = nbt.m_128459_("hardmode_chance");
            this.hardmode_loss = nbt.m_128459_("hardmode_loss");
            this.modernfix_warning = nbt.m_128471_("modernfix_warning");
            this.HardmodeOn = nbt.m_128471_("HardmodeOn");
            this.hardmode_threshold = nbt.m_128459_("hardmode_threshold");
            this.old_hardmode = nbt.m_128471_("old_hardmode");
            this.threshold_decay_interval = nbt.m_128459_("threshold_decay_interval");
            this.threshold_decay = nbt.m_128459_("threshold_decay");
            this.decay_reset = nbt.m_128471_("decay_reset");
            this.heart_25 = nbt.m_128459_("heart_25");
            this.heart_50 = nbt.m_128459_("heart_50");
            this.heart_75 = nbt.m_128459_("heart_75");
            this.true_damage = nbt.m_128471_("true_damage");
            this.craving_compat_toggle = nbt.m_128471_("craving_compat_toggle");
            this.craving_recovered = nbt.m_128459_("craving_recovered");
            this.grace_sleep_toggle = nbt.m_128471_("grace_sleep_toggle");
            this.grace_firstdeath_toggle = nbt.m_128471_("grace_firstdeath_toggle");
            this.grace_determination_toggle = nbt.m_128471_("grace_determination_toggle");
            this.grace_sleep_duration = nbt.m_128459_("grace_sleep_duration");
            this.grace_firstdeath_duration = nbt.m_128459_("grace_firstdeath_duration");
            this.grace_determination_duration = nbt.m_128459_("grace_determination_duration");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("toggle_partial", this.toggle_partial);
            nbt.m_128379_("toggle_full", this.toggle_full);
            nbt.m_128379_("toggle_passive", this.toggle_passive);
            nbt.m_128379_("toggle_sleep", this.toggle_sleep);
            nbt.m_128379_("toggle_determination", this.toggle_determination);
            nbt.m_128379_("timer_reset", this.timer_reset);
            nbt.m_128379_("determination_cooldown_deaths", this.determination_cooldown_deaths);
            nbt.m_128347_("original_max_health", this.original_max_health);
            nbt.m_128347_("healing_timer", this.healing_timer);
            nbt.m_128347_("deaths_for_determination", this.deaths_for_determination);
            nbt.m_128347_("determination_set_cooldown", this.determination_set_cooldown);
            nbt.m_128347_("health_loss", this.health_loss);
            nbt.m_128347_("partial_recovered", this.partial_recovered);
            nbt.m_128347_("passive_recovered", this.passive_recovered);
            nbt.m_128347_("sleep_recovered", this.sleep_recovered);
            nbt.m_128347_("determination_recovered", this.determination_recovered);
            nbt.m_128347_("hardmode_chance", this.hardmode_chance);
            nbt.m_128347_("hardmode_loss", this.hardmode_loss);
            nbt.m_128379_("modernfix_warning", this.modernfix_warning);
            nbt.m_128379_("HardmodeOn", this.HardmodeOn);
            nbt.m_128347_("hardmode_threshold", this.hardmode_threshold);
            nbt.m_128379_("old_hardmode", this.old_hardmode);
            nbt.m_128347_("threshold_decay_interval", this.threshold_decay_interval);
            nbt.m_128347_("threshold_decay", this.threshold_decay);
            nbt.m_128379_("decay_reset", this.decay_reset);
            nbt.m_128347_("heart_25", this.heart_25);
            nbt.m_128347_("heart_50", this.heart_50);
            nbt.m_128347_("heart_75", this.heart_75);
            nbt.m_128379_("true_damage", this.true_damage);
            nbt.m_128379_("craving_compat_toggle", this.craving_compat_toggle);
            nbt.m_128347_("craving_recovered", this.craving_recovered);
            nbt.m_128379_("grace_sleep_toggle", this.grace_sleep_toggle);
            nbt.m_128379_("grace_firstdeath_toggle", this.grace_firstdeath_toggle);
            nbt.m_128379_("grace_determination_toggle", this.grace_determination_toggle);
            nbt.m_128347_("grace_sleep_duration", this.grace_sleep_duration);
            nbt.m_128347_("grace_firstdeath_duration", this.grace_firstdeath_duration);
            nbt.m_128347_("grace_determination_duration", this.grace_determination_duration);
            return nbt;
        }

        public void markSyncDirty() {
            this.m_77762_();
            this._syncDirty = true;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "diminishing_health_worldvars";
        boolean _syncDirty = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void markSyncDirty() {
            this.m_77762_();
            this._syncDirty = true;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> DiminishingHealthMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> DiminishingHealthMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> DiminishingHealthMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerTickUpdateSyncPlayerVariables(TickEvent.PlayerTickEvent event) {
            Player player;
            if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> {
                    if (capability._syncDirty) {
                        DiminishingHealthMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability));
                        capability._syncDirty = false;
                    }
                });
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            event.getOriginal().getCapability(PLAYER_VARIABLES).ifPresent(original -> event.getEntity().getCapability(PLAYER_VARIABLES).ifPresent(clone -> {
                clone.currentMaxHealth = original.currentMaxHealth;
                clone.RecoveryDayTicks = original.RecoveryDayTicks;
                clone.one_health_deaths = original.one_health_deaths;
                clone.determination_on_cooldown = original.determination_on_cooldown;
                clone.determination_cooldown_duration = original.determination_cooldown_duration;
                clone.determination_uses = original.determination_uses;
                clone.health_halved_times = original.health_halved_times;
                clone.full_recovery_times = original.full_recovery_times;
                clone.partial_recovery_times = original.partial_recovery_times;
                clone.usedItemID = original.usedItemID;
                clone.reapply_timer = original.reapply_timer;
                clone.bb_effect_toggle = original.bb_effect_toggle;
                clone.hardmode_visual = original.hardmode_visual;
                clone.threshold_current = original.threshold_current;
                clone.Threshold_timer = original.Threshold_timer;
                clone.player_health = original.player_health;
                clone.pending_health_update = original.pending_health_update;
                clone.reaper_timer = original.reaper_timer;
                clone.Hitless_timer = original.Hitless_timer;
                clone.graced = original.graced;
                clone.grace_on_respawn = original.grace_on_respawn;
                if (!event.isWasDeath()) {
                    // empty if block
                }
            }));
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)player2.m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)player2.m_9236_());
                if (mapdata != null) {
                    DiminishingHealthMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    DiminishingHealthMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            ServerPlayer player;
            WorldVariables worlddata;
            Player player2 = event.getEntity();
            if (player2 instanceof ServerPlayer && (worlddata = WorldVariables.get((LevelAccessor)(player = (ServerPlayer)player2).m_9236_())) != null) {
                DiminishingHealthMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }

        @SubscribeEvent
        public static void onWorldTick(TickEvent.LevelTickEvent event) {
            Level level;
            if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level2);
                if (worldVariables._syncDirty) {
                    DiminishingHealthMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)level2).m_46472_()), (Object)new SavedDataSyncMessage(1, worldVariables));
                    worldVariables._syncDirty = false;
                }
                MapVariables mapVariables = MapVariables.get((LevelAccessor)level2);
                if (mapVariables._syncDirty) {
                    DiminishingHealthMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, mapVariables));
                    mapVariables._syncDirty = false;
                }
            }
        }
    }
}

