/*
 * Decompiled with CFR 0.152.
 */
package net.levi.stolz.playerSit;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.levi.stolz.playerSit.command.SitCommand;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public final class PlayerSit
extends JavaPlugin
implements Listener {
    private final Map<UUID, Interaction> seats = new HashMap<UUID, Interaction>();
    private NamespacedKey seatKey;

    public void onEnable() {
        this.seatKey = new NamespacedKey((Plugin)this, "playersit-seat");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("sit")).setExecutor((CommandExecutor)new SitCommand(this));
    }

    public void onDisable() {
        for (Interaction seat : this.seats.values()) {
            if (seat == null || seat.isDead()) continue;
            seat.remove();
        }
        this.seats.clear();
    }

    public void toggleSit(Player player) {
        if (this.isSitting(player)) {
            this.unsit(player);
        } else {
            this.sit(player);
        }
    }

    private boolean isSitting(Player player) {
        Interaction seat = this.seats.get(player.getUniqueId());
        return seat != null && !seat.isDead() && player.isInsideVehicle() && player.getVehicle() != null && player.getVehicle().getUniqueId().equals(seat.getUniqueId());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sit(Player player) {
        if (player.isInsideVehicle()) {
            Entity vehicle = player.getVehicle();
            Interaction tracked = this.seats.get(player.getUniqueId());
            if (vehicle instanceof Interaction) {
                Interaction stand = (Interaction)vehicle;
                if (tracked != null && tracked.getUniqueId().equals(stand.getUniqueId())) {
                    this.unsit(player);
                    return;
                }
            }
            player.sendMessage((Component)Component.text((String)"You are already riding something.", (TextColor)NamedTextColor.RED));
            return;
        }
        if (!player.isOnGround() || player.isFlying() || player.isGliding()) {
            player.sendMessage((Component)Component.text((String)"You must be on the ground to sit.", (TextColor)NamedTextColor.RED));
            return;
        }
        Location seatLoc = this.computeSeatLocation(player);
        World world = seatLoc.getWorld();
        if (world == null) {
            return;
        }
        Interaction stand = (Interaction)world.spawn(seatLoc, Interaction.class, spawned -> {
            spawned.setInvulnerable(true);
            spawned.setPersistent(false);
            spawned.setGravity(false);
            spawned.setSilent(true);
            spawned.setInteractionWidth(0.3f);
            spawned.setInteractionHeight(0.3f);
            PersistentDataContainer pdc = spawned.getPersistentDataContainer();
            pdc.set(this.seatKey, PersistentDataType.BYTE, (Object)1);
            spawned.setVelocity(new Vector(0, 0, 0));
        });
        stand.addPassenger((Entity)player);
        this.seats.put(player.getUniqueId(), stand);
    }

    private void unsit(Player player) {
        Interaction seat = this.seats.remove(player.getUniqueId());
        if (seat != null) {
            if (player.isInsideVehicle() && player.getVehicle() != null && player.getVehicle().getUniqueId().equals(seat.getUniqueId())) {
                player.leaveVehicle();
            }
            if (!seat.isDead()) {
                seat.remove();
            }
        }
    }

    private Location computeSeatLocation(Player player) {
        Location base = player.getLocation().clone();
        base.setY(base.getY() - 0.25);
        return base;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.unsit(e.getPlayer());
    }

    @EventHandler
    public void onKick(PlayerKickEvent e) {
        this.unsit(e.getPlayer());
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent e) {
        this.unsit(e.getEntity());
    }

    @EventHandler
    public void onTeleport(final PlayerTeleportEvent e) {
        if (this.isSitting(e.getPlayer())) {
            new BukkitRunnable(this){
                final /* synthetic */ PlayerSit this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.unsit(e.getPlayer());
                }
            }.runTask((Plugin)this);
        }
    }

    @EventHandler
    public void onVehicleExit(VehicleExitEvent e) {
        LivingEntity livingEntity = e.getExited();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        final Player player = (Player)livingEntity;
        Vehicle vehicle = e.getVehicle();
        Interaction stand = this.seats.get(player.getUniqueId());
        if (stand != null && vehicle.getUniqueId().equals(stand.getUniqueId())) {
            new BukkitRunnable(this){
                final /* synthetic */ PlayerSit this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.unsit(player);
                }
            }.runTask((Plugin)this);
        }
    }

    @EventHandler
    public void onEntityDismount(EntityDismountEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        final Player player = (Player)entity;
        Entity dismounted = e.getDismounted();
        Interaction tracked = this.seats.get(player.getUniqueId());
        if (tracked != null && dismounted.getUniqueId().equals(tracked.getUniqueId())) {
            new BukkitRunnable(this){
                final /* synthetic */ PlayerSit this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.unsit(player);
                }
            }.runTask((Plugin)this);
            return;
        }
        PersistentDataContainer pdc = dismounted.getPersistentDataContainer();
        Byte marker = (Byte)pdc.get(this.seatKey, PersistentDataType.BYTE);
        if (marker != null && marker == 1) {
            new BukkitRunnable(this){
                final /* synthetic */ PlayerSit this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.unsit(player);
                }
            }.runTask((Plugin)this);
        }
    }

    @EventHandler
    public void onToggleSneak(PlayerToggleSneakEvent e) {
        if (!e.isSneaking()) {
            return;
        }
        final Player player = e.getPlayer();
        if (this.isSitting(player)) {
            new BukkitRunnable(this){
                final /* synthetic */ PlayerSit this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.unsit(player);
                }
            }.runTask((Plugin)this);
        }
    }
}

