/*
 * Decompiled with CFR 0.152.
 */
package com.modcustom.moddev.utils;

import com.modcustom.moddev.network.Network;
import com.modcustom.moddev.utils.ActivityArea;
import com.modcustom.moddev.utils.ActivityRecord;
import com.modcustom.moddev.utils.Area;
import com.modcustom.moddev.utils.ClientCachedData;
import com.modcustom.moddev.utils.GameData;
import com.modcustom.moddev.utils.SoundSetting;
import com.modcustom.moddev.utils.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010*\u001a\u00020)\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\b\u0010%\u001a\u0004\u0018\u00010$\u0012\f\u00100\u001a\b\u0012\u0004\u0012\u00020/0.\u00a2\u0006\u0004\b=\u0010>J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0007J\r\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0015\u0010\u0007R\u0017\u0010\u0017\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R$\u0010!\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010\u0004R\u0019\u0010%\u001a\u0004\u0018\u00010$8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0017\u0010*\u001a\u00020)8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u001d\u00100\u001a\b\u0012\u0004\u0012\u00020/0.8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u0011\u00107\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R$\u00108\u001a\u0002042\u0006\u0010\u001c\u001a\u0002048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u00106R$\u0010;\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b;\u0010\"\u001a\u0004\b<\u0010\u0004\u00a8\u0006?"}, d2={"Lcom/modcustom/moddev/utils/Activity;", "", "", "checkEmpty", "()Z", "", "clearBlocks", "()V", "compareAndFinish", "noScore", "finish", "(Z)V", "Lnet/minecraft/class_2338;", "pos", "isInActivityArea", "(Lnet/minecraft/class_2338;)Z", "Lcom/modcustom/moddev/utils/SoundSetting;", "soundSetting", "playSound", "(Lcom/modcustom/moddev/utils/SoundSetting;)V", "start", "tick", "Lcom/modcustom/moddev/utils/ActivityArea;", "area", "Lcom/modcustom/moddev/utils/ActivityArea;", "getArea", "()Lcom/modcustom/moddev/utils/ActivityArea;", "", "<set-?>", "countdown", "I", "getCountdown", "()I", "finished", "Z", "getFinished", "", "initiator", "Ljava/lang/String;", "getInitiator", "()Ljava/lang/String;", "Lnet/minecraft/class_3218;", "level", "Lnet/minecraft/class_3218;", "getLevel", "()Lnet/minecraft/class_3218;", "", "Lnet/minecraft/class_3222;", "players", "Ljava/util/Set;", "getPlayers", "()Ljava/util/Set;", "", "getRuntime", "()J", "runtime", "startTime", "J", "getStartTime", "started", "getStarted", "<init>", "(Lnet/minecraft/class_3218;Lcom/modcustom/moddev/utils/ActivityArea;Ljava/lang/String;Ljava/util/Set;)V", "SpeedBuild-common"})
@SourceDebugExtension(value={"SMAP\nActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Activity.kt\ncom/modcustom/moddev/utils/Activity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n766#2:138\n857#2,2:139\n1855#2,2:141\n1179#2,2:143\n1253#2,4:145\n1855#2,2:149\n1855#2,2:151\n*S KotlinDebug\n*F\n+ 1 Activity.kt\ncom/modcustom/moddev/utils/Activity\n*L\n54#1:138\n54#1:139,2\n56#1:141,2\n95#1:143,2\n95#1:145,4\n115#1:149,2\n134#1:151,2\n*E\n"})
public final class Activity {
    @NotNull
    private final class_3218 level;
    @NotNull
    private final ActivityArea area;
    @Nullable
    private final String initiator;
    @NotNull
    private final Set<class_3222> players;
    private long startTime;
    private int countdown;
    private boolean started;
    private boolean finished;

    public Activity(@NotNull class_3218 level, @NotNull ActivityArea area, @Nullable String initiator, @NotNull Set<class_3222> players) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        Intrinsics.checkNotNullParameter(players, (String)"players");
        this.level = level;
        this.area = area;
        this.initiator = initiator;
        this.players = players;
        this.countdown = this.area.getConfig().getCountdown() * 20;
        if (this.area.getConfig().getSimpleMode()) {
            this.start();
        } else {
            this.area.startCopyTask(this.level);
            Network.INSTANCE.previewActivity(this);
        }
    }

    @NotNull
    public final class_3218 getLevel() {
        return this.level;
    }

    @NotNull
    public final ActivityArea getArea() {
        return this.area;
    }

    @Nullable
    public final String getInitiator() {
        return this.initiator;
    }

    @NotNull
    public final Set<class_3222> getPlayers() {
        return this.players;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final int getCountdown() {
        return this.countdown;
    }

    public final boolean getStarted() {
        return this.started;
    }

    public final boolean getFinished() {
        return this.finished;
    }

    public final long getRuntime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public final void start() {
        if (!this.started && !this.finished) {
            this.startTime = System.currentTimeMillis();
            this.started = true;
            if (!this.area.getConfig().getSimpleMode()) {
                this.clearBlocks();
            }
            Network.startActivityTimer$default(Network.INSTANCE, this, 0L, 2, null);
            this.playSound(this.area.getConfig().getStartSound());
        }
    }

    public final void clearBlocks() {
        this.area.startResetConstructionAreaTask(this.level);
    }

    /*
     * WARNING - void declaration
     */
    public final void tick() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.players;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_3222 it = (class_3222)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.method_37908(), (Object)this.level) || !class_238.method_19316((class_3341)this.area.getBox().method_35410(64)).method_994(it.method_5829()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 it = (class_3222)element$iv;
            boolean bl = false;
            Network.INSTANCE.finishActivity(it);
        }
        this.players.removeIf(arg_0 -> Activity.tick$lambda$2((Function1)new Function1<class_3222, Boolean>(this){
            final /* synthetic */ Activity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull class_3222 it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !this.this$0.getLevel().method_8503().method_3760().method_14571().contains(it) || !Intrinsics.areEqual((Object)it.method_37908(), (Object)this.this$0.getLevel()) || !class_238.method_19316((class_3341)this.this$0.getArea().getBox().method_35410(64)).method_994(it.method_5829());
            }
        }, arg_0));
        if (this.players.isEmpty() || !this.level.method_8477(this.area.getBox().method_22874())) {
            this.finished = true;
            if (!this.started) {
                this.clearBlocks();
            }
            return;
        }
        if (this.area.getConfig().getSimpleMode() && this.checkEmpty()) {
            this.finish(true);
            return;
        }
        if (!this.started && !this.area.getConfig().getSimpleMode()) {
            String text = this.area.getConfig().formattedCountdownText((int)Math.ceil((double)this.countdown / 20.0));
            Network.INSTANCE.sendCountdownMessageForAll((Collection<? extends class_3222>)this.players, text, 20);
            if (this.countdown > 0) {
                if (this.countdown % 20 == 0) {
                    this.playSound(this.area.getConfig().getCountdownSound());
                }
                int n = this.countdown;
                this.countdown = n + -1;
            } else {
                this.start();
            }
            return;
        }
        if (this.started && !this.finished) {
            this.level.method_8503().execute(() -> Activity.tick$lambda$3(this));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void finish(boolean noScore) {
        block2: {
            this.finished = true;
            Network.INSTANCE.finishActivity(this, noScore ? -1 : this.area.getId(), this.getRuntime());
            if (noScore) break block2;
            this.playSound(this.area.getConfig().getFinishSound());
            MinecraftServer minecraftServer = this.level.method_8503();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            ActivityArea activityArea = GameData.Companion.getGameData(minecraftServer).getArea(this.area.getId());
            if (activityArea != null) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                ActivityArea it = activityArea;
                boolean bl = false;
                Iterable iterable = this.players;
                String string = this.initiator;
                int n = this.area.getId();
                List<ActivityRecord> list = it.getHistory();
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var10_10 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    class_3222 it2 = (class_3222)element$iv$iv;
                    boolean bl2 = false;
                    Pair pair = TuplesKt.to((Object)it2.method_5476().getString(), (Object)ClientCachedData.Companion.createSyncData(it2));
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map map = destination$iv$iv;
                long l = this.getRuntime();
                long l2 = this.startTime;
                Map map2 = map;
                String string2 = string;
                int n2 = n;
                list.add(new ActivityRecord(n2, string2, map2, l2, l));
                MinecraftServer minecraftServer2 = this.level.method_8503();
                Intrinsics.checkNotNullExpressionValue((Object)minecraftServer2, (String)"getServer(...)");
                Network.INSTANCE.updateAreaHistory(minecraftServer2, it);
            }
        }
    }

    public static /* synthetic */ void finish$default(Activity activity, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        activity.finish(bl);
    }

    private final void compareAndFinish() {
        class_3341 targetBox = this.area.getTarget().getBox();
        class_2338 targetMinPos = new class_2338(targetBox.method_35415(), targetBox.method_35416(), targetBox.method_35417());
        class_3341 constructionBox = this.area.getConstruction().getBox();
        class_2338 constructionMinPos = new class_2338(constructionBox.method_35415(), constructionBox.method_35416(), constructionBox.method_35417());
        for (class_2338 pos : UtilKt.blockSequence$default(targetBox, false, 1, null)) {
            class_2586 blockEntity1;
            class_2338 offsetPos = pos.method_10059((class_2382)targetMinPos).method_10081((class_2382)constructionMinPos);
            class_2680 state = this.level.method_8320(pos);
            class_2680 state1 = this.level.method_8320(offsetPos);
            if (!Intrinsics.areEqual((Object)state.method_26204(), (Object)state1.method_26204())) {
                return;
            }
            Collection collection = state.method_28501();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getProperties(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_2769 it = (class_2769)element$iv;
                boolean bl = false;
                if (!state1.method_28498(it)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)state.method_11654(it), (Object)state1.method_11654(it))) continue;
                return;
            }
            class_2586 blockEntity = this.level.method_8321(pos);
            if (blockEntity == null) continue;
            if (this.level.method_8321(offsetPos) == null) {
                return;
            }
            if (blockEntity.method_11017() != blockEntity1.method_11017()) {
                return;
            }
            if (Intrinsics.areEqual((Object)blockEntity.method_38244(), (Object)blockEntity1.method_38244())) continue;
            return;
        }
        Activity.finish$default(this, false, 1, null);
    }

    private final boolean checkEmpty() {
        return this.area.isConstructionAreaEmpty(this.level);
    }

    public final boolean isInActivityArea(@NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return Area.contains$default(this.area, pos, 0, 2, null);
    }

    public final void playSound(@NotNull SoundSetting soundSetting) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)soundSetting, (String)"soundSetting");
            class_3414 class_34142 = soundSetting.getSound();
            if (class_34142 == null) break block1;
            class_3414 $this$playSound_u24lambda_u248 = class_34142;
            boolean bl = false;
            Iterable $this$forEach$iv = this.players;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 it = (class_3222)element$iv;
                boolean bl2 = false;
                it.method_17356($this$playSound_u24lambda_u248, class_3419.field_15246, soundSetting.getVolume(), soundSetting.getPitch());
            }
        }
    }

    private static final boolean tick$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void tick$lambda$3(Activity this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.compareAndFinish();
    }
}

