/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.simplerecallpotion.item.potion;

import java.util.Objects;
import net.gobies.simplerecallpotion.Config;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RecallPotionItem
extends Item {
    public RecallPotionItem(Item.Properties properties) {
        super(properties.stacksTo(16).rarity(Rarity.RARE));
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return (Integer)Config.RECALL_POTION_USE_TIME.get();
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return (Boolean)Config.RECALL_POTION_GLOW.get();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.getItem() instanceof RecallPotionItem) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        block9: {
            if (!level.isClientSide && entity instanceof ServerPlayer) {
                ServerLevel serverWorld;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                boolean interDimensional = (Boolean)Config.RECALL_POTION_INTERDIMENSIONAL.get();
                ResourceKey currentDimension = level.dimension();
                ResourceKey respawnDimension = serverPlayer.getRespawnDimension();
                Object object = interDimensional ? serverPlayer.server.getLevel(respawnDimension) : (serverWorld = currentDimension == respawnDimension ? Objects.requireNonNull(level.getServer()).getLevel(currentDimension) : null);
                if (serverWorld != null) {
                    try {
                        DimensionTransition.PostDimensionTransition postTransition = entity1 -> {};
                        DimensionTransition respawnLocation = serverPlayer.findRespawnPositionAndUseSpawnBlock(false, postTransition);
                        if (!respawnLocation.missingRespawnBlock()) {
                            Vec3 respawnVec = respawnLocation.pos();
                            Vec3 currentVec = serverPlayer.position();
                            RecallPotionItem.spawnPortalParticles(serverPlayer, currentVec);
                            serverPlayer.teleportTo(serverWorld, respawnVec.x, respawnVec.y, respawnVec.z, serverPlayer.getYRot(), serverPlayer.getXRot());
                            RecallPotionItem.spawnPortalParticles(serverPlayer, respawnVec);
                            serverPlayer.resetFallDistance();
                            serverWorld.playSound(null, respawnVec.x, respawnVec.y, respawnVec.z, SoundEvents.ENDERMAN_TELEPORT, serverPlayer.getSoundSource(), 1.0f, 1.0f);
                            serverPlayer.playSound(SoundEvents.ENDERMAN_TELEPORT, 2.0f, 1.0f);
                            serverPlayer.getCooldowns().addCooldown(stack.getItem(), 20 * (Integer)Config.RECALL_POTION_COOLDOWN.get());
                            if (!serverPlayer.isCreative()) {
                                if (stack.getCount() == 1) {
                                    serverPlayer.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.GLASS_BOTTLE, 1));
                                } else {
                                    stack.shrink(1);
                                    serverPlayer.addItem(new ItemStack((ItemLike)Items.GLASS_BOTTLE, 1));
                                }
                            }
                            break block9;
                        }
                        serverPlayer.displayClientMessage((Component)Component.translatable((String)"simple.recall.respawn"), true);
                    }
                    catch (Exception e) {
                        serverPlayer.displayClientMessage((Component)Component.translatable((String)"simple.recall.respawn"), true);
                    }
                } else {
                    serverPlayer.displayClientMessage((Component)Component.translatable((String)"simple.recall.dimension"), true);
                }
            }
        }
        return stack;
    }

    private static void spawnPortalParticles(ServerPlayer serverPlayer, Vec3 position) {
        if (position != null) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        Vec3 particlePos = position.add((double)x * 0.3, (double)y * 0.5, (double)z * 0.3);
                        serverPlayer.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.PORTAL, true, particlePos.x, particlePos.y, particlePos.z, 0.1f, 0.1f, 0.1f, 0.1f, 10));
                    }
                }
            }
        }
    }
}

