/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.simplerecallpotion.item.potion;

import java.util.Objects;
import java.util.Optional;
import net.gobies.simplerecallpotion.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RecallPotionItem
extends Item {
    public RecallPotionItem(Item.Properties properties) {
        super(properties.m_41487_(16).m_41497_(Rarity.RARE));
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return (Integer)Config.RECALL_POTION_USE_TIME.get();
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return (Boolean)Config.RECALL_POTION_GLOW.get();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() instanceof RecallPotionItem) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        block9: {
            if (!level.f_46443_ && entity instanceof ServerPlayer) {
                ServerLevel serverWorld;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                boolean interDimensional = (Boolean)Config.RECALL_POTION_INTERDIMENSIONAL.get();
                ResourceKey currentDimension = level.m_46472_();
                ResourceKey respawnDimension = serverPlayer.m_8963_();
                Object object = interDimensional ? serverPlayer.f_8924_.m_129880_(respawnDimension) : (serverWorld = currentDimension == respawnDimension ? Objects.requireNonNull(level.m_7654_()).m_129880_(currentDimension) : null);
                if (serverWorld != null) {
                    try {
                        Optional respawnLocation = Player.m_36130_((ServerLevel)serverWorld, (BlockPos)Objects.requireNonNull(serverPlayer.m_8961_()), (float)serverPlayer.m_8962_(), (boolean)false, (boolean)false);
                        if (respawnLocation.isPresent()) {
                            Vec3 respawnVec = (Vec3)respawnLocation.get();
                            Vec3 currentVec = serverPlayer.m_20182_();
                            RecallPotionItem.spawnPortalParticles(serverPlayer, currentVec);
                            serverPlayer.m_8999_(serverWorld, respawnVec.f_82479_, respawnVec.f_82480_, respawnVec.f_82481_, serverPlayer.m_146908_(), serverPlayer.m_146909_());
                            RecallPotionItem.spawnPortalParticles(serverPlayer, respawnVec);
                            serverPlayer.m_183634_();
                            serverWorld.m_6263_(null, respawnVec.f_82479_, respawnVec.f_82480_, respawnVec.f_82481_, SoundEvents.f_11852_, serverPlayer.m_5720_(), 1.0f, 1.0f);
                            serverPlayer.m_5496_(SoundEvents.f_11852_, 2.0f, 1.0f);
                            serverPlayer.m_36335_().m_41524_(stack.m_41720_(), 20 * (Integer)Config.RECALL_POTION_COOLDOWN.get());
                            if (!serverPlayer.m_7500_()) {
                                if (stack.m_41613_() == 1) {
                                    serverPlayer.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42590_, 1));
                                } else {
                                    stack.m_41774_(1);
                                    serverPlayer.m_36356_(new ItemStack((ItemLike)Items.f_42590_, 1));
                                }
                            }
                            break block9;
                        }
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"simple.recall.respawn"), true);
                    }
                    catch (Exception e) {
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"simple.recall.respawn"), true);
                    }
                } else {
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"simple.recall.dimension"), true);
                }
            }
        }
        return stack;
    }

    private static void spawnPortalParticles(ServerPlayer serverPlayer, Vec3 position) {
        if (position != null) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        Vec3 particlePos = position.m_82520_((double)x * 0.3, (double)y * 0.5, (double)z * 0.3);
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123760_, true, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.1f, 0.1f, 0.1f, 0.1f, 10));
                    }
                }
            }
        }
    }
}

