/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.lewmc.essence.EssenceConfiguration;
import net.lewmc.essence.EssenceIntegrations;
import net.lewmc.essence.admin.ModuleAdmin;
import net.lewmc.essence.chat.ModuleChat;
import net.lewmc.essence.core.ModuleCore;
import net.lewmc.essence.core.TypePendingRequests;
import net.lewmc.essence.core.TypePlayer;
import net.lewmc.essence.core.UtilCommand;
import net.lewmc.essence.core.UtilUpdate;
import net.lewmc.essence.economy.ModuleEconomy;
import net.lewmc.essence.environment.ModuleEnvironment;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.FoundryConfig;
import net.lewmc.essence.external.Logger;
import net.lewmc.essence.external.Registry;
import net.lewmc.essence.external.Security;
import net.lewmc.essence.external.folialib.FoliaLib;
import net.lewmc.essence.gamemode.ModuleGamemode;
import net.lewmc.essence.inventory.ModuleInventory;
import net.lewmc.essence.kit.ModuleKit;
import net.lewmc.essence.stats.ModuleStats;
import net.lewmc.essence.team.ModuleTeam;
import net.lewmc.essence.teleportation.ModuleTeleportation;
import net.lewmc.essence.world.ModuleWorld;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Essence
extends JavaPlugin {
    public Logger log;
    public ConcurrentMap<String, String[]> teleportRequests = new ConcurrentHashMap<String, String[]>();
    public ConcurrentMap<UUID, TypePendingRequests.TypePendingClears> pendingClears = new ConcurrentHashMap<UUID, TypePendingRequests.TypePendingClears>();
    public List<UUID> teleportingPlayers = new ArrayList<UUID>();
    public ConcurrentMap<CommandSender, CommandSender> msgHistory = new ConcurrentHashMap<CommandSender, CommandSender>();
    public ConcurrentMap<UUID, TypePlayer> players = new ConcurrentHashMap<UUID, TypePlayer>();
    public ConcurrentMap<String, Object> config;
    public List<UUID> flyingPlayers = new ArrayList<UUID>();
    public boolean hasPendingUpdate = false;
    public Random rand = new Random();
    public FoundryConfig foundryConfig;
    public EssenceIntegrations integrations;
    public boolean verbose;
    public Files messageStore;
    public boolean deferredTasksRun = false;

    public void onEnable() {
        this.foundryConfig = new FoundryConfig(this);
        this.foundryConfig.pluginId = "ES";
        this.log = new Logger(this.foundryConfig);
        this.log.info("");
        this.log.info("\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u27cd");
        this.log.info("\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588  \u27cd    \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500 Essence by LewMC \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        this.log.info("\u2588\u2588           \u2588\u2588\u2588\u2588\u2588         \u2588\u2588\u2588\u2588   \u2502   \u2502 Stress-free server utilities.");
        this.log.info("\u2588\u2588           \u2588\u2588\u2588\u2588           \u2588\u2588\u2588   \u2502   \u2514 Version " + this.getDescription().getVersion());
        this.log.info("\u2588\u2588    \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588    \u2588\u2588\u2588\u2588\u2588    \u2588\u2588   \u2502");
        this.log.info("\u2588\u2588    \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588     \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588   \u2502");
        this.log.info("\u2588\u2588          \u2588\u2588\u2588\u2588\u2588          \u2588\u2588\u2588\u2588   \u2502   \u250c\u2500\u2500 \u203c \u2500\u2500 Found a problem?  \u2500\u2500 \u203c \u2500\u2500");
        this.log.info("\u2588\u2588          \u2588\u2588\u2588\u2588\u2588\u2588\u2588         \u2588\u2588\u2588   \u2502   \u2502 Please report any problems to");
        this.log.info("\u2588\u2588    \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588     \u2588\u2588   \u2502   \u2502 our GitHub issues page at");
        this.log.info("\u2588\u2588    \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588    \u2588\u2588\u2588\u2588\u2588    \u2588\u2588   \u2502   \u2514 github.com/lewmc/essence");
        this.log.info("\u2588\u2588           \u2588\u2588\u2588\u2588           \u2588\u2588\u2588   \u2502");
        this.log.info("\u2588\u2588           \u2588\u2588\u2588\u2588\u2588         \u2588\u2588\u2588\u2588   \u2502");
        this.log.info("\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588   \u2502   \u250c\u2500\u2500 \u2713 \u2500\u2500 Enjoying Essence? \u2500\u2500 \u2713 \u2500\u2500");
        this.log.info("\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588   \u2502   \u2502 Support LewMC and Essence by");
        this.log.info("\u27cd                                 \u2502   \u2514 visiting lewmc.net/support");
        this.log.info("  \u27cd \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518");
        this.log.info("");
        this.log.info("Beginning startup...");
        this.log.info("");
        this.checkConfigExists();
        UtilUpdate update = new UtilUpdate(this);
        update.migrate();
        this.startupConfig();
        update.VersionCheck();
        update.UpdateLanguage();
        if (this.verbose) {
            this.log.warn("Verbose mode is ENABLED.");
            this.log.warn("This will likely cause a lot of console spam.");
            this.log.warn("You should only enable this if you're having problems.");
            this.log.info("");
        }
        if (!Bukkit.getOnlineMode()) {
            this.log.severe(">> Your server is running in offline mode.");
            this.log.warn(">> Player data saved in offline mode may not work properly if you switch back to online mode.");
            this.log.warn(">> Player data saved in online mode may not work properly in offline mode.");
            this.log.info("");
        }
        this.checkForEssentials();
        this.checkForPaper();
        this.initFileSystem();
        this.loadModules();
        this.integrations = new EssenceIntegrations(this);
        if (!this.integrations.loadPlaceholderAPI() && this.verbose) {
            this.log.warn("PlaceholderAPI not found! Using local placeholders.");
        }
        if (!this.integrations.loadVaultEconomy() && this.verbose) {
            this.log.warn("Vault not found or is disabled! Using local economy.");
        }
        if (!this.integrations.loadVaultChat() && this.verbose) {
            this.log.warn("Vault not found! Using local chat.");
        }
        this.integrations.loadMetrics();
        this.checkLanguageSystem();
        this.log.info("");
        this.log.info("Startup completed.");
        new Security(this.foundryConfig).startWatchdog();
    }

    private void checkForPaper() {
        UtilCommand cmd = new UtilCommand(this);
        if (!cmd.isPaperCompatible()) {
            this.log.severe("You are running " + this.getServer().getName());
            this.log.severe("Some commands have been disabled, please see https://bit.ly/essencepaper for help.");
            this.log.severe("To get full plugin support please consider using Paper instead.");
            this.log.severe("You can download it from https://papermc.io");
        } else {
            this.log.info("Running server jar: " + this.getServer().getName());
            if (this.verbose) {
                FoliaLib flib = new FoliaLib((Plugin)this);
                this.log.info("Is Folia: " + flib.isFolia());
            }
            this.log.info("");
        }
    }

    private void checkForEssentials() {
        if (this.getServer().getPluginManager().getPlugin("Essentials") != null || this.getServer().getPluginManager().getPlugin("EssentialsX") != null) {
            this.log.severe("Essentials is installed alongside Essence.");
            this.log.severe("Essence's commands clash with Essentials, this may cause issues later down the line.");
            this.log.severe("If you require commands that are in Essentials but not in Essence, please remove Essence from the server.");
            this.log.severe("All Essence commands are implemented in Essentials in a similar way.");
        }
    }

    private void initFileSystem() {
        File rulesFile;
        File kitsFile;
        File spawnsFile;
        File warpsFile;
        File statsFolder = new File(String.valueOf(this.getDataFolder()) + File.separator + "data" + File.separator + "players");
        if (!statsFolder.exists() && !statsFolder.mkdirs()) {
            this.log.severe("Unable to make data folder.");
            this.log.warn("The plugin is being disabled, most of the plugin's features will not work without the data folder.");
            this.log.warn("Please create a folder called 'data' in the 'Essence' folder.");
            this.log.warn("Please create a folder called 'players' in the 'data' folder.");
            this.log.warn("Once this is complete, restart the server and Essence will re-enable.");
            this.log.info("");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        if (!(warpsFile = new File(String.valueOf(this.getDataFolder()) + File.separator + "data" + File.separator + "warps.yml")).exists()) {
            this.saveResource("data/warps.yml", false);
        }
        if (!(spawnsFile = new File(String.valueOf(this.getDataFolder()) + File.separator + "data" + File.separator + "worlds.yml")).exists()) {
            this.saveResource("data/worlds.yml", false);
        }
        if (!(kitsFile = new File(String.valueOf(this.getDataFolder()) + File.separator + "data" + File.separator + "kits.yml")).exists()) {
            this.saveResource("data/kits.yml", false);
        }
        if (!(rulesFile = new File(String.valueOf(this.getDataFolder()) + File.separator + "rules.txt")).exists()) {
            this.saveResource("rules.txt", false);
        }
    }

    private void checkLanguageSystem() {
        File setLang = new File(String.valueOf(this.getDataFolder()) + File.separator + "language" + File.separator + String.valueOf(this.config.get("language")) + ".yml");
        if (!setLang.exists()) {
            this.log.severe("Language file '" + String.valueOf(this.config.get("language")) + "' does not exist!");
            this.log.severe("Please check the file and try again.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        this.messageStore = new Files(this.foundryConfig, this);
        this.messageStore.load("language/" + String.valueOf(this.config.get("language")) + ".yml");
    }

    private void loadModules() {
        Registry reg = new Registry(this.foundryConfig, this);
        new ModuleCore(this, reg);
        if (((Boolean)this.config.get("admin.enabled")).booleanValue()) {
            new ModuleAdmin(this, reg);
            if (this.verbose) {
                this.log.info("Loaded module: ADMIN");
            }
        } else if (this.verbose) {
            this.log.warn("Disabled module: ADMIN");
        }
        if (((Boolean)this.config.get("chat.enabled")).booleanValue()) {
            new ModuleChat(this, reg);
            if (this.verbose) {
                this.log.info("Loaded module: CHAT");
            }
        } else if (this.verbose) {
            this.log.warn("Disabled module: CHAT");
        }
        if (((Boolean)this.config.get("economy.enabled")).booleanValue()) {
            new ModuleEconomy(this, reg);
            if (this.verbose) {
                this.log.info("Loaded module: ECONOMY");
            }
        } else if (this.verbose) {
            this.log.warn("Disabled module: ECONOMY");
        }
        if (((Boolean)this.config.get("environment.enabled")).booleanValue()) {
            new ModuleEnvironment(this, reg);
            if (this.verbose) {
                this.log.info("Loaded module: ENVIRONMENT");
            }
        } else if (this.verbose) {
            this.log.warn("Disabled module: ENVIRONMENT");
        }
        if (((Boolean)this.config.get("gamemode.enabled")).booleanValue()) {
            new ModuleGamemode(this, reg);
            if (this.verbose) {
                this.log.info("Loaded module: GAMEMODE");
            }
        } else if (this.verbose) {
            this.log.warn("Disabled module: GAMEMODE");
        }
        if (((Boolean)this.config.get("inventory.enabled")).booleanValue()) {
            new ModuleInventory(this, reg);
            if (this.verbose) {
                this.log.info("Loaded module: INVENTORY");
            }
        } else if (this.verbose) {
            this.log.warn("Disabled module: INVENTORY");
        }
        if (((Boolean)this.config.get("kit.enabled")).booleanValue()) {
            new ModuleKit(this, reg);
            if (this.verbose) {
                this.log.info("Loaded module: KIT");
            }
        } else if (this.verbose) {
            this.log.warn("Disabled module: KIT");
        }
        if (((Boolean)this.config.get("stats.enabled")).booleanValue()) {
            new ModuleStats(this, reg);
            if (this.verbose) {
                this.log.info("Loaded module: STATS");
            }
        } else if (this.verbose) {
            this.log.warn("Disabled module: STATS");
        }
        if (((Boolean)this.config.get("team.enabled")).booleanValue()) {
            new ModuleTeam(this, reg);
            if (this.verbose) {
                this.log.info("Loaded module: TEAM");
            }
        } else if (this.verbose) {
            this.log.warn("Disabled module: TEAM");
        }
        if (((Boolean)this.config.get("teleportation.enabled")).booleanValue()) {
            new ModuleTeleportation(this, reg);
            if (this.verbose) {
                this.log.info("Loaded module: TELEPORTATION");
            }
        } else if (this.verbose) {
            this.log.warn("Disabled module: TELEPORTATION");
        }
        if (((Boolean)this.config.get("world.enabled")).booleanValue()) {
            new ModuleWorld(this, reg);
            if (this.verbose) {
                this.log.info("Loaded module: WORLD");
            }
        } else if (this.verbose) {
            this.log.warn("Disabled module: WORLD");
        }
    }

    public void startupConfig() {
        this.config = new EssenceConfiguration(this).startup();
        this.foundryConfig.verbose = this.verbose = ((Boolean)this.config.get("advanced.verbose")).booleanValue();
    }

    private void checkConfigExists() {
        Files configFile = new Files(this.foundryConfig, this);
        if (!configFile.exists("config.yml")) {
            this.saveDefaultConfig();
            if (!configFile.exists("config.yml")) {
                Logger log = new Logger(this.foundryConfig);
                log.severe("The server was unable to create Essence's configuration file!");
                log.severe("You can download a blank config file from the link below.");
                log.severe("https://github.com/LewMC/Essence/blob/main/src/main/resources/config.yml");
                log.severe("Please contact lewmc.net/help for help and to report the issue.");
            }
        }
    }

    public void onDisable() {
        new FoliaLib((Plugin)this).getScheduler().cancelAllTasks();
        if (this.messageStore != null) {
            this.messageStore.close();
        }
    }
}

