/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.chat;

import java.util.Arrays;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPlaceholder;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandMsg
extends FoundryCommand {
    private final Essence plugin;

    public CommandMsg(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.chat.msg";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage message = new UtilMessage(this.plugin, cs);
        if (args.length > 1) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().equalsIgnoreCase(args[0])) continue;
                if (cs instanceof ConsoleCommandSender || !new UtilPlayer(this.plugin).playerIsIgnoring(Bukkit.getPlayer((String)cs.getName()).getUniqueId(), p.getUniqueId())) {
                    String msg = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                    msg = new UtilPlaceholder(this.plugin, cs).replaceAll(msg);
                    String[] repl = new String[]{cs.getName(), p.getName(), msg};
                    message.send("msg", "send", repl);
                    message.sendTo((CommandSender)p, "msg", "send", repl);
                    this.plugin.msgHistory.put((CommandSender)p, cs);
                } else {
                    message.send("ignore", "cantmessage", new String[]{p.getName()});
                }
                return true;
            }
            message.send("generic", "playernotfound");
        } else {
            message.send("msg", "usage");
        }
        return true;
    }
}

