/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.chat;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilCommand;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.external.Security;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandNick
extends FoundryCommand {
    private final Essence plugin;

    public CommandNick(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.chat.nick.self";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilCommand cmd = new UtilCommand(this.plugin);
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        UtilPlayer pu = new UtilPlayer(this.plugin);
        if (args.length == 1) {
            if (cmd.console(cs)) {
                msg.send("nick", "consoleusage");
                return true;
            }
            if (new Security(this.plugin.foundryConfig).hasSpecialCharacters(args[0])) {
                msg.send("nick", "specialchars");
                return true;
            }
            if (args[0].equalsIgnoreCase("off")) {
                if (pu.removeDisplayname(cs)) {
                    msg.send("nick", "success", new String[]{cs.getName()});
                }
                return true;
            }
            if (pu.setDisplayname(cs, args[0])) {
                msg.send("nick", "success", new String[]{args[0]});
            }
        } else if (args.length == 2) {
            UtilPermission perms = new UtilPermission(this.plugin, cs);
            if (!perms.has("essence.chat.nick.other")) {
                return perms.not();
            }
            Player player = Bukkit.getPlayer((String)args[0]);
            if (player == null) {
                msg.send("generic", "playernotfound");
                return true;
            }
            if (new Security(this.plugin.foundryConfig).hasSpecialCharacters(args[1])) {
                msg.send("nick", "specialchars");
                return true;
            }
            if (args[1].equalsIgnoreCase("off")) {
                if (pu.removeDisplayname((CommandSender)player)) {
                    msg.send("nick", "successother", new String[]{args[0], player.getName()});
                    msg.sendTo((CommandSender)player, "nick", "changedby", new String[]{cs.getName(), player.getName()});
                }
                return true;
            }
            if (pu.setDisplayname((CommandSender)player, args[1])) {
                msg.send("nick", "successother", new String[]{args[0], args[1]});
                msg.sendTo((CommandSender)player, "nick", "changedby", new String[]{cs.getName(), args[1]});
            }
        } else {
            msg.send("nick", "usage");
        }
        return true;
    }
}

