/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.environment;

import java.util.Objects;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.environment.UtilEnvironment;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandTime
extends FoundryCommand {
    private final Essence plugin;

    public CommandTime(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.environment.time";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilEnvironment env = new UtilEnvironment((Plugin)this.plugin);
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        if (args.length == 0 || args.length == 1 && (Objects.equals(args[0], "time") || Objects.equals(args[0], "get") || Objects.equals(args[0], "query") || Objects.equals(args[0], "current") || Objects.equals(args[0], "now"))) {
            if (cs instanceof Player) {
                Player p = (Player)cs;
                msg.send("environment", "time", new String[]{String.valueOf(env.getTime(p.getWorld())), p.getWorld().getName()});
                return true;
            } else {
                msg.send("environment", "timeconsoleusage");
            }
            return true;
        }
        if (args.length == 1 || args.length == 2 && Objects.equals(args[0], "set")) {
            if (Objects.equals(args[0], "set")) {
                args[0] = args[1];
            }
            if (cs instanceof Player) {
                Player p = (Player)cs;
                if (!new UtilPermission(this.plugin, cs).has("essence.environment.time.set")) return new UtilPermission(this.plugin, cs).not();
                if (args[0].equalsIgnoreCase("day") || args[0].equalsIgnoreCase("morning")) {
                    env.setTime(p.getWorld(), UtilEnvironment.Time.DAY);
                } else if (args[0].equalsIgnoreCase("noon") || args[0].equalsIgnoreCase("midday")) {
                    env.setTime(p.getWorld(), UtilEnvironment.Time.MIDDAY);
                } else if (args[0].equalsIgnoreCase("evening")) {
                    env.setTime(p.getWorld(), UtilEnvironment.Time.EVENING);
                } else if (args[0].equalsIgnoreCase("night")) {
                    env.setTime(p.getWorld(), UtilEnvironment.Time.NIGHT);
                } else if (args[0].equalsIgnoreCase("midnight")) {
                    env.setTime(p.getWorld(), UtilEnvironment.Time.MIDNIGHT);
                } else if (args[0].equalsIgnoreCase("sunrise")) {
                    env.setTime(p.getWorld(), UtilEnvironment.Time.SUNRISE);
                } else {
                    try {
                        env.setTime(p.getWorld(), Long.parseLong(args[0]));
                    }
                    catch (NumberFormatException e) {
                        msg.send("generic", "unknowntime", new String[]{args[0]});
                        msg.send("generic", "timehelp");
                        return true;
                    }
                }
                msg.send("environment", "timeset", new String[]{String.valueOf(env.getTime(p.getWorld())), p.getWorld().getName()});
                return true;
            }
            if (Bukkit.getWorld((String)args[0]) != null) {
                msg.send("environment", "time", new String[]{String.valueOf(env.getTime(Bukkit.getWorld((String)args[0]))), args[0]});
                return true;
            } else {
                msg.send("generic", "worldnotfound", new String[]{args[0]});
            }
            return true;
        }
        if (args.length != 2) return true;
        if (cs instanceof Player) {
            msg.send("environment", "timeplayerusage", new String[]{args[0]});
            return true;
        }
        if (!new UtilPermission(this.plugin, cs).has("essence.environment.time.set")) return new UtilPermission(this.plugin, cs).not();
        if (Bukkit.getWorld((String)args[0]) == null) {
            msg.send("generic", "worldnotfound", new String[]{args[0]});
        }
        if (args[1].equalsIgnoreCase("day") || args[1].equalsIgnoreCase("morning")) {
            env.setTime(Bukkit.getWorld((String)args[0]), UtilEnvironment.Time.DAY);
        } else if (args[1].equalsIgnoreCase("noon") || args[1].equalsIgnoreCase("midday")) {
            env.setTime(Bukkit.getWorld((String)args[0]), UtilEnvironment.Time.MIDDAY);
        } else if (args[1].equalsIgnoreCase("evening")) {
            env.setTime(Bukkit.getWorld((String)args[0]), UtilEnvironment.Time.EVENING);
        } else if (args[1].equalsIgnoreCase("night")) {
            env.setTime(Bukkit.getWorld((String)args[0]), UtilEnvironment.Time.NIGHT);
        } else if (args[1].equalsIgnoreCase("midnight")) {
            env.setTime(Bukkit.getWorld((String)args[0]), UtilEnvironment.Time.MIDNIGHT);
        } else if (args[1].equalsIgnoreCase("sunrise")) {
            env.setTime(Bukkit.getWorld((String)args[0]), UtilEnvironment.Time.SUNRISE);
        } else {
            try {
                env.setTime(Bukkit.getWorld((String)args[0]), Long.parseLong(args[1]));
            }
            catch (NumberFormatException e) {
                msg.send("generic", "unknowntime", new String[]{args[1]});
                msg.send("generic", "timehelp");
                return true;
            }
        }
        msg.send("environment", "timeset", new String[]{String.valueOf(env.getTime(Bukkit.getWorld((String)args[0]))), args[0]});
        return true;
    }
}

