/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.environment;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.environment.UtilEnvironment;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandWeather
extends FoundryCommand {
    private final Essence plugin;

    public CommandWeather(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.environment.weather";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilEnvironment env = new UtilEnvironment((Plugin)this.plugin);
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        if (args.length == 0) {
            if (cs instanceof Player) {
                Player p = (Player)cs;
                msg.send("environment", "weather", new String[]{env.getWeather(p.getWorld()).toString(), p.getWorld().getName()});
                return true;
            } else {
                msg.send("environment", "weatherconsoleusage");
            }
            return true;
        } else if (args.length == 1) {
            if (cs instanceof Player) {
                Player p = (Player)cs;
                if (!new UtilPermission(this.plugin, cs).has("essence.environment.weather.set")) return new UtilPermission(this.plugin, cs).not();
                if (args[0].equalsIgnoreCase("clear") || args[0].equalsIgnoreCase("sun") || args[0].equalsIgnoreCase("sunny")) {
                    env.setWeather(p.getWorld(), UtilEnvironment.Weather.CLEAR);
                } else if (args[0].equalsIgnoreCase("rain") || args[0].equalsIgnoreCase("raining") || args[0].equalsIgnoreCase("downpour")) {
                    env.setWeather(p.getWorld(), UtilEnvironment.Weather.RAIN);
                } else if (args[0].equalsIgnoreCase("thunder") || args[0].equalsIgnoreCase("lightning") || args[0].equalsIgnoreCase("storm")) {
                    env.setWeather(p.getWorld(), UtilEnvironment.Weather.THUNDER);
                } else {
                    msg.send("generic", "unknownweather", new String[]{args[0]});
                    return true;
                }
                msg.send("environment", "weatherset", new String[]{env.getWeather(p.getWorld()).toString(), p.getWorld().getName()});
                return true;
            } else if (Bukkit.getWorld((String)args[0]) != null) {
                msg.send("environment", "weather", new String[]{env.getWeather(Bukkit.getWorld((String)args[0])).toString(), args[0]});
                return true;
            } else {
                msg.send("generic", "worldnotfound", new String[]{args[0]});
            }
            return true;
        } else {
            if (args.length != 2) return true;
            if (cs instanceof Player) {
                msg.send("environment", "weatherplayerusage", new String[]{args[0]});
                return true;
            } else {
                if (!new UtilPermission(this.plugin, cs).has("essence.environment.weather.set")) return new UtilPermission(this.plugin, cs).not();
                if (Bukkit.getWorld((String)args[0]) == null) {
                    msg.send("generic", "worldnotfound", new String[]{args[0]});
                }
                if (args[1].equalsIgnoreCase("clear") || args[1].equalsIgnoreCase("sun") || args[1].equalsIgnoreCase("sunny")) {
                    env.setWeather(Bukkit.getWorld((String)args[0]), UtilEnvironment.Weather.CLEAR);
                } else if (args[1].equalsIgnoreCase("rain") || args[1].equalsIgnoreCase("raining") || args[1].equalsIgnoreCase("downpour")) {
                    env.setWeather(Bukkit.getWorld((String)args[0]), UtilEnvironment.Weather.RAIN);
                } else if (args[1].equalsIgnoreCase("thunder") || args[1].equalsIgnoreCase("lightning") || args[1].equalsIgnoreCase("storm")) {
                    env.setWeather(Bukkit.getWorld((String)args[0]), UtilEnvironment.Weather.THUNDER);
                } else {
                    msg.send("generic", "unknownweather", new String[]{args[1]});
                    return true;
                }
                msg.send("environment", "weatherset", new String[]{env.getWeather(Bukkit.getWorld((String)args[0])).toString(), args[0]});
            }
        }
        return true;
    }
}

