/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.external;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import net.lewmc.essence.external.FoundryConfig;
import net.lewmc.essence.external.Logger;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class IBukkit {
    private final JavaPlugin plugin;
    private final FoundryConfig config;

    public IBukkit(FoundryConfig config, JavaPlugin plugin) {
        this.config = config;
        this.plugin = plugin;
    }

    public CommandMap getCommandMap() {
        try {
            Field f = this.plugin.getServer().getClass().getDeclaredField("commandMap");
            f.setAccessible(true);
            CommandMap cm = (CommandMap)f.get(this.plugin.getServer());
            if (cm != null) {
                return cm;
            }
            new Logger(this.config).severe("Foundry tried to access Bukkit internals (IBukkit.getCommandMap) but couldn't find it.");
            return null;
        }
        catch (Exception e) {
            new Logger(this.config).severe("Foundry tried to access Bukkit internals (IBukkit.getCommandMap) and died. Threw exception: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public PluginCommand constructRuntimeCommand(String name) {
        PluginCommand command = null;
        try {
            Constructor c = PluginCommand.class.getDeclaredConstructor(String.class, JavaPlugin.class);
            c.setAccessible(true);
            command = (PluginCommand)c.newInstance(name, this.plugin);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            new Logger(this.config).severe("Foundry tried to access Bukkit internals (IBukkit.constructRuntimeCommand) on '" + name + "' and died. Threw exception: " + e.getMessage());
            e.printStackTrace();
        }
        return command;
    }

    public PluginManager getPluginManager() {
        try {
            return this.plugin.getServer().getPluginManager();
        }
        catch (Exception e) {
            new Logger(this.config).severe("Foundry tried to access Bukkit internals (IBukkit.getPluginManager) and died. Threw exception: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

