/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.external.folialib.impl;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import net.lewmc.essence.external.folialib.FoliaLib;
import net.lewmc.essence.external.folialib.impl.SpigotImplementation;
import net.lewmc.essence.external.folialib.util.ImplementationTestsUtil;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PaperImplementation
extends SpigotImplementation {
    private Method teleportAsyncMethod;

    public PaperImplementation(FoliaLib foliaLib) {
        super(foliaLib);
        if (ImplementationTestsUtil.isAsyncTeleportSupported()) {
            try {
                this.teleportAsyncMethod = Entity.class.getMethod("teleportAsync", Location.class, PlayerTeleportEvent.TeleportCause.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to initialize PaperImplementation", e);
            }
        }
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location) {
        return this.teleportAsync(entity, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (!ImplementationTestsUtil.isAsyncTeleportSupported()) {
            return super.teleportAsync(entity, location, cause);
        }
        try {
            return (CompletableFuture)this.teleportAsyncMethod.invoke((Object)entity, location, cause);
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.teleportAsync(entity, location, cause);
        }
    }
}

