/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.inventory;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilItem;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.external.Parser;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandGive
extends FoundryCommand {
    private final Essence plugin;
    private UtilMessage msg;

    public CommandGive(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.inventory.give";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        this.msg = new UtilMessage(this.plugin, cs);
        UtilPlayer up = new UtilPlayer(this.plugin);
        UtilPermission perm = new UtilPermission(this.plugin, cs);
        UtilItem ui = new UtilItem(this.plugin);
        if (args.length == 1) {
            if (cs instanceof Player) {
                Player player = (Player)cs;
                if (ui.itemIsBlacklisted(args[0])) {
                    this.msg.send("give", "blacklisted", new String[]{args[0]});
                    return true;
                }
                if (up.givePlayerItem(player, args[0], 1)) {
                    this.msg.send("give", "gaveself", new String[]{"1", args[0]});
                    return true;
                } else {
                    this.msg.send("generic", "itemnotfound", new String[]{args[0]});
                }
                return true;
            }
            this.msg.send("give", "usage");
            return true;
        }
        if (args.length == 2) {
            if (cs instanceof Player) {
                Player player = (Player)cs;
                if (new Parser().isNumeric(args[1])) {
                    try {
                        int amount = this.parseItemAmount(args[1]);
                        if (ui.itemIsBlacklisted(args[0])) {
                            this.msg.send("give", "blacklisted", new String[]{args[0]});
                            return true;
                        }
                        if (up.givePlayerItem(player, args[0], amount)) {
                            this.msg.send("give", "gaveself", new String[]{String.valueOf(amount), args[0]});
                            return true;
                        } else {
                            this.msg.send("generic", "itemnotfound", new String[]{args[1]});
                        }
                        return true;
                    }
                    catch (NumberFormatException e) {
                        this.msg.send("generic", "exception");
                        this.plugin.log.warn(e.getMessage());
                    }
                }
            }
            if (!perm.has("essence.inventory.give.other")) {
                return perm.not();
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                this.msg.send("generic", "playernotfound");
                return true;
            }
            if (ui.itemIsBlacklisted(args[1])) {
                this.msg.send("give", "blacklisted", new String[]{args[1]});
                return true;
            }
            if (up.givePlayerItem(target, args[1], 1)) {
                this.msg.send("give", "gaveother", new String[]{"1", args[1], target.getName()});
                return true;
            } else {
                this.msg.send("give", "itemnotfound", new String[]{args[1]});
            }
            return true;
        }
        if (args.length == 3) {
            if (!perm.has("essence.inventory.give.other")) {
                return perm.not();
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                this.msg.send("generic", "playernotfound");
                return true;
            }
            try {
                int amount = this.parseItemAmount(args[2]);
                if (ui.itemIsBlacklisted(args[1])) {
                    this.msg.send("give", "blacklisted", new String[]{args[1]});
                    return true;
                }
                if (up.givePlayerItem(target, args[1], amount)) {
                    this.msg.send("give", "gaveother", new String[]{String.valueOf(amount), args[1], target.getName()});
                    return true;
                }
                this.msg.send("give", "itemnotfound", new String[]{args[1]});
                return true;
            }
            catch (NumberFormatException e) {
                this.msg.send("give", "usage");
            }
            return true;
        }
        this.msg.send("give", "usage");
        return true;
    }

    private int parseItemAmount(String amount) {
        try {
            int iAmount = Integer.parseInt(amount);
            if (iAmount <= 0 || iAmount > 2304) {
                this.msg.send("give", "invalidamount", new String[]{amount});
                return 0;
            }
            return iAmount;
        }
        catch (Exception e) {
            this.msg.send("give", "invalidamount", new String[]{amount});
            return 0;
        }
    }
}

