/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.stats;

import java.util.Objects;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHeal
extends FoundryCommand {
    private final Essence plugin;

    public CommandHeal(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.stats.heal";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage message = new UtilMessage(this.plugin, cs);
        if (args.length > 0) {
            return this.healOther(new UtilPermission(this.plugin, cs), cs, message, args);
        }
        if (!(cs instanceof Player)) {
            message.send("heal", "usage");
            return true;
        }
        return this.healSelf(cs, message);
    }

    private void healPlayer(Player player) {
        player.setHealth(Objects.requireNonNull(player.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getValue());
        player.setFoodLevel(20);
        player.setSaturation(10.0f);
        player.setExhaustion(0.0f);
        player.setFireTicks(0);
        player.setRemainingAir(player.getMaximumAir());
        player.clearActivePotionEffects();
    }

    private boolean healSelf(CommandSender sender, UtilMessage message) {
        Player player = (Player)sender;
        this.healPlayer(player);
        message.send("heal", "beenhealed");
        return true;
    }

    private boolean healOther(UtilPermission permission, CommandSender sender, UtilMessage message, String[] args) {
        if (permission.has("essence.stats.heal.other")) {
            String pName = args[0];
            Player p = Bukkit.getPlayer((String)pName);
            if (p != null) {
                message.send("heal", "healed", new String[]{p.getName()});
                if (!(sender instanceof Player)) {
                    message.sendTo((CommandSender)p, "heal", "serverhealed");
                } else {
                    message.sendTo((CommandSender)p, "heal", "healedby", new String[]{sender.getName()});
                }
                this.healPlayer(p);
            } else {
                message.send("generic", "playernotfound");
            }
            return true;
        }
        return permission.not();
    }
}

