/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.team;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Security;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.team.UtilTeam;
import net.lewmc.essence.teleportation.home.UtilHome;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandSetthome
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandSetthome(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.home.team.create";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        UtilTeam tu = new UtilTeam(this.plugin, msg);
        Player p = (Player)cs;
        String team = tu.getPlayerTeam(p.getUniqueId());
        if (team == null) {
            msg.send("team", "noteam");
            return true;
        }
        if (!tu.getRule(team, "allow-team-homes")) {
            msg.send("team", "disallowedhomes");
            return true;
        }
        String name = args.length == 0 ? "home" : args[0];
        Location loc = p.getLocation();
        Files dataUtil = new Files(this.plugin.foundryConfig, this.plugin);
        dataUtil.load("data/teams/" + team + ".yml");
        if (new Security(this.plugin.foundryConfig).hasSpecialCharacters(name.toLowerCase())) {
            dataUtil.close();
            msg.send("teamhome", "specialchars");
            return true;
        }
        String homeName = "homes." + name.toLowerCase();
        if (dataUtil.get(homeName) != null) {
            dataUtil.close();
            msg.send("teamhome", "alreadyexists");
            return true;
        }
        UtilHome hu = new UtilHome(this.plugin);
        int homeLimit = new UtilPermission(this.plugin, cs).getTeamHomesLimit(p);
        if (hu.getTeamHomeCount(p) >= homeLimit && homeLimit != -1) {
            msg.send("teamhome", "hitlimit");
            return true;
        }
        dataUtil.set(homeName + ".creator", p.getUniqueId().toString());
        dataUtil.set(homeName + ".world", loc.getWorld().getName());
        dataUtil.set(homeName + ".X", loc.getX());
        dataUtil.set(homeName + ".Y", loc.getY());
        dataUtil.set(homeName + ".Z", loc.getZ());
        dataUtil.set(homeName + ".yaw", Float.valueOf(loc.getYaw()));
        dataUtil.set(homeName + ".pitch", Float.valueOf(loc.getPitch()));
        dataUtil.save();
        msg.send("teamhome", "created", new String[]{name});
        return true;
    }
}

