/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.team;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Logger;
import net.lewmc.essence.external.Permissions;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.team.UtilTeam;
import net.lewmc.essence.teleportation.home.UtilHome;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandThome
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandThome(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.home.team.use";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        String chatHomeName;
        Object homeName;
        Player p = (Player)cs;
        Logger log = new Logger(this.plugin.foundryConfig);
        UtilMessage message = new UtilMessage(this.plugin, cs);
        UtilTeleport teleUtil = new UtilTeleport(this.plugin);
        UtilTeam tu = new UtilTeam(this.plugin, message);
        String team = tu.getPlayerTeam(p.getUniqueId());
        if (team == null) {
            message.send("team", "noteam");
            return true;
        }
        if (!tu.getRule(team, "allow-team-homes")) {
            message.send("team", "disallowedhomes");
            return true;
        }
        int waitTime = (Integer)this.plugin.config.get("teleportation.home.wait");
        if (!teleUtil.cooldownSurpassed(p, "home")) {
            message.send("teleport", "tryagain", new String[]{String.valueOf(teleUtil.cooldownRemaining(p, "home"))});
            return true;
        }
        Files dataUtil = new Files(this.plugin.foundryConfig, this.plugin);
        dataUtil.load("data/teams/" + team + ".yml");
        if (args.length == 1) {
            homeName = "homes." + args[0].toLowerCase();
            chatHomeName = args[0].toLowerCase();
            if (dataUtil.get((String)homeName) == null) {
                dataUtil.close();
                message.send("teamhome", "notfound", new String[]{args[0].toLowerCase()});
                return true;
            }
        } else {
            homeName = "homes.home";
            chatHomeName = "home";
            if (dataUtil.get((String)homeName) == null) {
                if (new Permissions(cs).has("essence.home.team.list")) {
                    dataUtil.close();
                    UtilHome hu = new UtilHome(this.plugin);
                    StringBuilder setHomes = hu.getTeamHomesList(team);
                    if (setHomes == null) {
                        message.send("teamhome", "noneset");
                        return true;
                    }
                    message.send("teamhome", "list", new String[]{setHomes.toString()});
                    return true;
                }
                message.send("teamhome", "notfound", new String[]{"home"});
            }
        }
        if (dataUtil.get((String)homeName) == null) {
            dataUtil.close();
            message.send("generic", "exception");
            log.warn("Player " + String.valueOf(p) + " attempted to teleport home to " + chatHomeName + " but couldn't due to an error.");
            log.warn("Error: Unable to load from configuration file, please check configuration file.");
            return true;
        }
        if (dataUtil.getString((String)homeName + ".world") == null) {
            dataUtil.close();
            message.send("generic", "exception");
            log.warn("Player " + String.valueOf(p) + " attempted to teleport home to " + chatHomeName + " but couldn't due to an error.");
            log.warn("Error: world is null, please check configuration file.");
            return true;
        }
        teleUtil.setCooldown(p, "home");
        World world = Bukkit.getServer().getWorld(dataUtil.getString((String)homeName + ".world"));
        if (world == null) {
            message.send("generic", "exception");
            log.warn("Player " + String.valueOf(p) + " attempted to teleport home to " + chatHomeName + " but couldn't due to an error.");
            log.warn("Error: world is null, please check configuration file.");
        }
        teleUtil.doTeleport(p, world, dataUtil.getDouble((String)homeName + ".X"), dataUtil.getDouble((String)homeName + ".Y"), dataUtil.getDouble((String)homeName + ".Z"), (float)dataUtil.getDouble((String)homeName + ".yaw"), (float)dataUtil.getDouble((String)homeName + ".pitch"), waitTime, true);
        dataUtil.close();
        if (waitTime > 0) {
            message.send("warp", "teleportingin", new String[]{chatHomeName, "" + waitTime});
        } else {
            message.send("warp", "teleportingnow", new String[]{chatHomeName});
        }
        return true;
    }
}

