/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.external.command.FoundryCommand;
import net.lewmc.essence.teleportation.UtilLocation;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandBack
extends FoundryCommand {
    private final Essence plugin;
    private final UtilPlayer up;

    public CommandBack(Essence plugin) {
        this.plugin = plugin;
        this.up = new UtilPlayer(plugin);
    }

    @Override
    protected String requiredPermission() {
        return "essence.teleport.back";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        if (args.length == 0) {
            if (!(cs instanceof Player)) {
                msg.send("back", "usage");
                return true;
            }
            this.backSelf((Player)cs, msg);
        } else if (args.length == 1) {
            UtilPermission perms = new UtilPermission(this.plugin, cs);
            if (!perms.has("essence.teleport.back.other")) {
                return perms.not();
            }
            this.backOther(cs, msg, args[0]);
        } else {
            msg.send("back", "usage");
        }
        return true;
    }

    private void backSelf(Player p, UtilMessage msg) {
        int waitTime;
        if (this.up.getPlayer(p.getUniqueId(), UtilPlayer.KEYS.LAST_LOCATION_WORLD) == null) {
            msg.send("back", "cant");
            return;
        }
        int n = waitTime = this.plugin.config.get("teleportation.back.wait") != null ? (Integer)this.plugin.config.get("teleportation.back.wait") : 0;
        if (Bukkit.getServer().getWorld(this.up.getPlayer(p.getUniqueId(), UtilPlayer.KEYS.LAST_LOCATION_WORLD).toString()) == null) {
            msg.send("back", "cant");
            return;
        }
        new UtilLocation(this.plugin).sendBack(p, waitTime);
        if (waitTime == 0) {
            msg.send("back", "going");
        }
    }

    private void backOther(CommandSender cs, UtilMessage msg, String targetName) {
        int waitTime;
        Player targetPlayer = Bukkit.getPlayer((String)targetName);
        if (targetPlayer == null) {
            msg.send("generic", "playernotfound");
            return;
        }
        int n = waitTime = this.plugin.config.get("teleportation.back.wait") != null ? (Integer)this.plugin.config.get("teleportation.back.wait") : 0;
        if (Bukkit.getServer().getWorld(this.up.getPlayer(targetPlayer.getUniqueId(), UtilPlayer.KEYS.LAST_LOCATION_WORLD).toString()) == null) {
            msg.send("back", "cantother", new String[]{targetPlayer.getName()});
            return;
        }
        new UtilLocation(this.plugin).sendBack(targetPlayer, waitTime);
        if (waitTime == 0) {
            msg.send("back", "goingother", new String[]{targetPlayer.getName()});
            new UtilMessage(this.plugin, (CommandSender)targetPlayer).send("back", "sentby", new String[]{cs.getName()});
        }
    }
}

