/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.command.FoundryCommand;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandTop
extends FoundryCommand {
    private final Essence plugin;

    public CommandTop(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.teleport.top";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        if (args.length == 0) {
            if (!(cs instanceof Player)) {
                msg.send("top", "usage");
                return true;
            }
            return this.topSelf((Player)cs, msg);
        }
        if (args.length == 1) {
            UtilPermission perms = new UtilPermission(this.plugin, cs);
            if (!perms.has("essence.teleport.other")) {
                return perms.not();
            }
            return this.topOther(cs, msg, args[0]);
        }
        msg.send("top", "usage");
        return true;
    }

    private boolean top(Player player, UtilMessage msg, CommandSender sender, boolean isSelf) {
        int waitTime;
        Location safeLocation = UtilTeleport.findFurthestLocation(player.getLocation(), UtilTeleport.Direction.UP, player);
        int n = waitTime = this.plugin.config.get("teleportation.top.wait") != null ? (Integer)this.plugin.config.get("teleportation.top.wait") : 0;
        if (safeLocation == null) {
            msg.send("top", "nosafelocation");
            return true;
        }
        if (player.getLocation().getBlockY() >= safeLocation.getBlockY()) {
            if (isSelf) {
                msg.send("top", "alreadyattop");
            } else {
                msg.send("top", "alreadyattopother", new String[]{player.getName()});
            }
            return true;
        }
        new UtilTeleport(this.plugin).doTeleport(player, safeLocation, waitTime, true);
        if (waitTime == 0) {
            if (isSelf) {
                msg.send("top", "going");
            } else {
                msg.send("top", "goingother", new String[]{player.getName()});
                new UtilMessage(this.plugin, (CommandSender)player).send("top", "sentby", new String[]{sender.getName()});
            }
        }
        return true;
    }

    private boolean topSelf(Player p, UtilMessage msg) {
        return this.top(p, msg, (CommandSender)p, true);
    }

    private boolean topOther(CommandSender cs, UtilMessage msg, String targetName) {
        Player targetPlayer = Bukkit.getPlayer((String)targetName);
        if (targetPlayer == null) {
            msg.send("generic", "playernotfound");
            return true;
        }
        return this.top(targetPlayer, msg, cs, false);
    }
}

