/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.home;

import java.util.Objects;
import java.util.Set;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.team.UtilTeam;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UtilHome {
    private final Essence plugin;

    public UtilHome(Essence plugin) {
        this.plugin = plugin;
    }

    public StringBuilder getHomesList(Player player) {
        Files dataUtil = new Files(this.plugin.foundryConfig, this.plugin);
        dataUtil.load(dataUtil.playerDataFile(player));
        Set<String> keys = dataUtil.getKeys("homes", false);
        if (keys == null || Objects.equals(keys.toString(), "[]")) {
            dataUtil.close();
            return null;
        }
        StringBuilder setHomes = new StringBuilder();
        int i = 0;
        for (String key : keys) {
            if (i == 0) {
                setHomes.append(key);
            } else {
                setHomes.append(", ").append(key);
            }
            ++i;
        }
        dataUtil.close();
        return setHomes;
    }

    public StringBuilder getTeamHomesList(String team) {
        Files dataUtil = new Files(this.plugin.foundryConfig, this.plugin);
        dataUtil.load("data/teams/" + team + ".yml");
        Set<String> keys = dataUtil.getKeys("homes", false);
        if (keys == null || Objects.equals(keys.toString(), "[]")) {
            dataUtil.close();
            return null;
        }
        StringBuilder setHomes = new StringBuilder();
        int i = 0;
        for (String key : keys) {
            if (i == 0) {
                setHomes.append(key);
            } else {
                setHomes.append(", ").append(key);
            }
            ++i;
        }
        dataUtil.close();
        return setHomes;
    }

    public int getHomeCount(Player player) {
        Files dataUtil = new Files(this.plugin.foundryConfig, this.plugin);
        dataUtil.load(dataUtil.playerDataFile(player));
        Set<String> homes = dataUtil.getKeys("homes", false);
        if (homes == null) {
            return 0;
        }
        return homes.size();
    }

    public int getTeamHomeCount(Player player) {
        UtilTeam teamUtil = new UtilTeam(this.plugin, new UtilMessage(this.plugin, (CommandSender)player));
        Files dataUtil = new Files(this.plugin.foundryConfig, this.plugin);
        dataUtil.load("data/teams/" + teamUtil.getPlayerTeam(player.getUniqueId()) + ".yml");
        Set<String> keys = dataUtil.getKeys("homes", false);
        int homes = 0;
        if (keys == null) {
            return homes;
        }
        for (String key : keys) {
            if (!Objects.equals(dataUtil.getString("homes." + key + ".creator"), player.getUniqueId().toString())) continue;
            ++homes;
        }
        return homes;
    }

    public boolean create(String homeName, OfflinePlayer player, Location loc) {
        if (player == null) {
            return false;
        }
        Files playerData = new Files(this.plugin.foundryConfig, this.plugin);
        playerData.load(playerData.playerDataFile(player));
        if (playerData.get(homeName) != null) {
            playerData.close();
            if (player.isOnline()) {
                UtilMessage message = new UtilMessage(this.plugin, (CommandSender)((Player)player));
                message.send("home", "alreadyexists");
            }
            return false;
        }
        playerData.set("homes." + homeName + ".world", loc.getWorld().getName());
        playerData.set("homes." + homeName + ".X", loc.getX());
        playerData.set("homes." + homeName + ".Y", loc.getY());
        playerData.set("homes." + homeName + ".Z", loc.getZ());
        playerData.set("homes." + homeName + ".yaw", Float.valueOf(loc.getYaw()));
        playerData.set("homes." + homeName + ".pitch", Float.valueOf(loc.getPitch()));
        return playerData.save();
    }
}

