/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.tp;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.teleportation.tp.UtilTeleportRequest;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandTpa
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandTpa(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.teleport.request.send";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        if (args.length == 0) {
            msg.send("teleport", "userrequired");
        } else {
            Player playerToRequest = this.plugin.getServer().getPlayer(args[0]);
            if (playerToRequest == null) {
                msg.send("generic", "playernotfound");
                return true;
            }
            if (playerToRequest.getName().equals(cs.getName())) {
                msg.send("generic", "cantyourself");
                return true;
            }
            UtilPlayer up = new UtilPlayer(this.plugin);
            if (!((Boolean)up.getPlayer(playerToRequest.getUniqueId(), UtilPlayer.KEYS.USER_ACCEPTING_TELEPORT_REQUESTS)).booleanValue()) {
                msg.send("teleport", "requestsdisabled", new String[]{playerToRequest.getName()});
                return true;
            }
            Player csP = (Player)cs;
            if (Boolean.valueOf(up.playerIsIgnoring(playerToRequest.getUniqueId(), csP.getUniqueId())).booleanValue()) {
                msg.send("ignore", "cantteleport", new String[]{playerToRequest.getName()});
                return true;
            }
            new UtilTeleportRequest(this.plugin).createRequest(cs.getName(), playerToRequest.getName(), false);
            msg.send("teleport", "requestsent");
            msg.sendToWithButtons((CommandSender)playerToRequest, "teleport", "requested", new String[]{cs.getName()}, "/tpaccept", "/tpdeny");
        }
        return true;
    }
}

