/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.tp;

import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.Logger;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.external.folialib.FoliaLib;
import net.lewmc.essence.teleportation.UtilLocation;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.WorldBorder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandTprandom
extends FoundryPlayerCommand {
    private final Essence plugin;
    private final FoliaLib flib;
    private final UtilTeleport teleUtil;

    public CommandTprandom(Essence plugin) {
        this.plugin = plugin;
        this.flib = new FoliaLib((Plugin)this.plugin);
        this.teleUtil = new UtilTeleport(this.plugin);
    }

    @Override
    protected String requiredPermission() {
        return "essence.teleport.random";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        WorldBorder wb;
        Player p = (Player)cs;
        UtilMessage message = new UtilMessage(this.plugin, cs);
        if (!this.teleUtil.cooldownSurpassed(p, "randomtp")) {
            message.send("teleport", "tryagain", new String[]{String.valueOf(this.teleUtil.cooldownRemaining(p, "randomtp"))});
            return true;
        }
        message.send("tprandom", "searching");
        try {
            wb = Objects.requireNonNull(Bukkit.getWorld((UUID)p.getWorld().getUID())).getWorldBorder();
        }
        catch (NullPointerException e) {
            new Logger(this.plugin.foundryConfig).warn("NullPointerException randomly teleporting: " + String.valueOf(e));
            message.send("generic", "exception");
            return true;
        }
        UtilLocation loc = new UtilLocation(this.plugin);
        if (this.flib.isFolia()) {
            this.flib.getScheduler().runAsync(wrappedTask -> {
                Random rand = new Random();
                Location center = wb.getCenter();
                double maxX = (double)center.getBlockX() + wb.getSize() / 2.0;
                double minX = (double)center.getBlockX() - wb.getSize() / 2.0;
                double maxZ = (double)center.getBlockZ() + wb.getSize() / 2.0;
                double minZ = (double)center.getBlockZ() - wb.getSize() / 2.0;
                int x = (int)(minX + (maxX - minX) * rand.nextDouble());
                int z = (int)(minZ + (maxZ - minZ) * rand.nextDouble());
                Location baseLoc = new Location(p.getWorld(), (double)x, 0.0, (double)z);
                this.flib.getScheduler().runAtLocation(baseLoc, wrappedTask2 -> {
                    int y = loc.GetGroundY(p.getWorld(), x, z);
                    for (int attempt = 1; y == -64 && attempt != 3; ++attempt) {
                        y = loc.GetGroundY(p.getWorld(), x, z);
                    }
                    Location teleportLocation = new Location(p.getWorld(), (double)x, (double)y, (double)z);
                    this.checkChunkLoaded(p, teleportLocation);
                });
            });
            return true;
        }
        Location center = wb.getCenter();
        double maxX = (double)center.getBlockX() + wb.getSize() / 2.0;
        double minX = (double)center.getBlockX() - wb.getSize() / 2.0;
        double maxZ = (double)center.getBlockZ() + wb.getSize() / 2.0;
        double minZ = (double)center.getBlockZ() - wb.getSize() / 2.0;
        int x = (int)(minX + (maxX - minX) * this.plugin.rand.nextDouble());
        int z = (int)(minZ + (maxZ - minZ) * this.plugin.rand.nextDouble());
        Location baseLoc = new Location(p.getWorld(), (double)x, 0.0, (double)z);
        this.flib.getScheduler().runAtLocation(baseLoc, wrappedTask -> {
            int y = loc.GetGroundY(p.getWorld(), x, z);
            for (int attempt = 1; y == -64 && attempt != 3; ++attempt) {
                y = loc.GetGroundY(p.getWorld(), x, z);
            }
            Location teleportLocation = new Location(p.getWorld(), (double)x, (double)y, (double)z);
            this.checkChunkLoaded(p, teleportLocation);
        });
        return true;
    }

    private void checkChunkLoaded(Player player, Location teleportLocation) {
        UtilMessage message = new UtilMessage(this.plugin, (CommandSender)player);
        if (teleportLocation.getY() == -64.0) {
            message.send("tprandom", "nosafe");
            return;
        }
        message.send("tprandom", "teleporting");
        if (this.flib.isFolia()) {
            this.flib.getScheduler().runAtLocation(teleportLocation, wrappedTask -> {
                Chunk chunk = teleportLocation.getChunk();
                if (!chunk.isLoaded()) {
                    message.send("tprandom", "generating");
                    chunk.load(true);
                }
                this.doTeleportation(player, teleportLocation);
            });
        } else {
            Chunk chunk = teleportLocation.getChunk();
            if (!chunk.isLoaded()) {
                message.send("tprandom", "generating");
                chunk.load(true);
            }
            this.doTeleportation(player, teleportLocation);
        }
    }

    private void doTeleportation(Player player, Location teleportLocation) {
        this.teleUtil.setCooldown(player, "randomtp");
        UtilTeleport tp = new UtilTeleport(this.plugin);
        tp.doTeleport(player, teleportLocation, 1, true);
    }
}

