/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.warp;

import java.util.Objects;
import java.util.Set;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CommandWarps
extends FoundryCommand {
    private final Essence plugin;

    public CommandWarps(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.warp.list";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        Files data = new Files(this.plugin.foundryConfig, this.plugin);
        data.load("/data/warps.yml");
        Set<String> keys = data.getKeys("warps", false);
        if (keys == null || Objects.equals(keys.toString(), "[]")) {
            data.close();
            msg.send("warp", "noneset");
            return true;
        }
        StringBuilder warps = new StringBuilder();
        int i = 0;
        for (String key : keys) {
            if (i == 0) {
                warps.append(key);
            } else {
                warps.append(", ").append(key);
            }
            ++i;
        }
        data.close();
        msg.send("warp", "list", new String[]{warps.toString()});
        return true;
    }
}

