/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.warp;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.Files;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UtilWarp {
    private final Essence plugin;

    public UtilWarp(Essence plugin) {
        this.plugin = plugin;
    }

    public int getWarpCount(Player player) {
        Files dataUtil = new Files(this.plugin.foundryConfig, this.plugin);
        dataUtil.load("data/warps.yml");
        Set<String> keys = dataUtil.getKeys("warps", false);
        int warps = 0;
        if (keys == null) {
            return warps;
        }
        for (String key : keys) {
            if (!Objects.equals(dataUtil.getString("warps." + key + ".creator"), player.getUniqueId().toString())) continue;
            ++warps;
        }
        return warps;
    }

    public boolean create(String warpName, UUID playerUUID, Location loc) {
        Files warpsData = new Files(this.plugin.foundryConfig, this.plugin);
        warpsData.load("data/warps.yml");
        if (warpsData.get("warps." + warpName) != null) {
            warpsData.close();
            if (this.plugin.getServer().getOfflinePlayer(playerUUID).isOnline()) {
                new UtilMessage(this.plugin, (CommandSender)this.plugin.getServer().getPlayer(playerUUID)).send("warp", "alreadyexists");
            }
            return false;
        }
        warpsData.set("warps." + warpName + ".creator", playerUUID.toString());
        warpsData.set("warps." + warpName + ".world", loc.getWorld().getName());
        warpsData.set("warps." + warpName + ".X", loc.getX());
        warpsData.set("warps." + warpName + ".Y", loc.getY());
        warpsData.set("warps." + warpName + ".Z", loc.getZ());
        warpsData.set("warps." + warpName + ".yaw", Float.valueOf(loc.getYaw()));
        warpsData.set("warps." + warpName + ".pitch", Float.valueOf(loc.getPitch()));
        return warpsData.save();
    }
}

