/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.world;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.lewmc.essence.Essence;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Logger;
import net.lewmc.essence.external.Parser;
import net.lewmc.essence.external.Security;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;

public class UtilWorld {
    private final Essence plugin;

    public UtilWorld(Essence plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WORLD_STATUS create(String name, Map<String, String> flags) {
        try {
            if (this.plugin.getServer().getWorld(name) != null) {
                return WORLD_STATUS.EXISTS;
            }
            if (new Files(this.plugin.foundryConfig, this.plugin).exists(this.plugin.getDataFolder().getPath() + "/" + name)) {
                return WORLD_STATUS.EXISTS;
            }
            WorldCreator wc = new WorldCreator(name);
            if (new Security(this.plugin.foundryConfig).hasSpecialCharacters(name) || name.equalsIgnoreCase("tp")) {
                return WORLD_STATUS.INVALID_CHARS;
            }
            if (flags.get("-e") != null) {
                if (flags.get("-e").equalsIgnoreCase("normal")) {
                    wc.environment(World.Environment.NORMAL);
                } else if (flags.get("-e").equalsIgnoreCase("nether")) {
                    wc.environment(World.Environment.NETHER);
                } else if (flags.get("-e").equalsIgnoreCase("end")) {
                    wc.environment(World.Environment.THE_END);
                } else {
                    if (!flags.get("-e").equalsIgnoreCase("custom")) return WORLD_STATUS.INVALID_E;
                    wc.environment(World.Environment.CUSTOM);
                }
            } else {
                wc.environment(World.Environment.NORMAL);
            }
            if (flags.get("-n") != null) {
                if (flags.get("-n").equalsIgnoreCase("true") || flags.get("-n").equalsIgnoreCase("yes") || flags.get("-n").equalsIgnoreCase("y")) {
                    wc.generateStructures(true);
                } else {
                    if (!flags.get("-n").equalsIgnoreCase("false") && !flags.get("-n").equalsIgnoreCase("no") && !flags.get("-n").equalsIgnoreCase("n")) return WORLD_STATUS.INVALID_N;
                    wc.generateStructures(false);
                }
            }
            if (flags.get("-h") != null) {
                if (flags.get("-h").equalsIgnoreCase("true") || flags.get("-h").equalsIgnoreCase("yes") || flags.get("-h").equalsIgnoreCase("y")) {
                    wc.hardcore(true);
                } else {
                    if (!flags.get("-h").equalsIgnoreCase("false") && !flags.get("-h").equalsIgnoreCase("no") && !flags.get("-h").equalsIgnoreCase("n")) return WORLD_STATUS.INVALID_H;
                    wc.hardcore(false);
                }
            }
            if (flags.get("-b") != null) {
                wc.biomeProvider(flags.get("-b"));
            }
            if (flags.get("-g") != null) {
                wc.generator(flags.get("-g"));
            }
            if (flags.get("-s") != null && new Parser().isNumeric(flags.get("-s"))) {
                try {
                    wc.seed(Long.parseLong(flags.get("-s")));
                }
                catch (NumberFormatException e) {
                    this.plugin.log.warn("Invalid seed specified for world " + name);
                    this.plugin.log.warn(e.getMessage());
                    return WORLD_STATUS.INVALID_S;
                }
            }
            if (flags.get("-t") != null) {
                if (flags.get("-t").equalsIgnoreCase("normal")) {
                    wc.type(WorldType.NORMAL);
                } else if (flags.get("-t").equalsIgnoreCase("flat")) {
                    wc.type(WorldType.FLAT);
                } else if (flags.get("-t").equalsIgnoreCase("amplified")) {
                    wc.type(WorldType.AMPLIFIED);
                } else {
                    if (!flags.get("-t").equalsIgnoreCase("large_biomes")) return WORLD_STATUS.INVALID_T;
                    wc.type(WorldType.LARGE_BIOMES);
                }
            } else {
                wc.type(WorldType.NORMAL);
            }
            if (flags.get("-gs") != null) {
                wc.generatorSettings(flags.get("-gs"));
            }
            if (!(flags.get("-a") == null || flags.get("-a").equalsIgnoreCase("true") || flags.get("-a").equalsIgnoreCase("yes") || flags.get("-a").equalsIgnoreCase("y") || flags.get("-a").equalsIgnoreCase("false") || flags.get("-a").equalsIgnoreCase("no") || flags.get("-a").equalsIgnoreCase("n"))) {
                return WORLD_STATUS.INVALID_A;
            }
            World newWorld = wc.createWorld();
            if (newWorld != null) {
                Files worldData = new Files(this.plugin.foundryConfig, this.plugin);
                worldData.load("data/worlds.yml");
                if (worldData.get("world." + String.valueOf(newWorld.getUID())) != null) return this.load(name);
                worldData.set("world." + String.valueOf(newWorld.getUID()) + ".name", name);
                worldData.set("world." + String.valueOf(newWorld.getUID()) + ".can-enter", true);
                if (flags.get("-a") != null) {
                    if (flags.get("-a").equalsIgnoreCase("true") || flags.get("-a").equalsIgnoreCase("yes") || flags.get("-a").equalsIgnoreCase("y")) {
                        worldData.set("world." + String.valueOf(newWorld.getUID()) + ".autoload", true);
                    } else if (flags.get("-a").equalsIgnoreCase("false") || flags.get("-a").equalsIgnoreCase("no") || flags.get("-a").equalsIgnoreCase("n")) {
                        worldData.set("world." + String.valueOf(newWorld.getUID()) + ".autoload", false);
                    }
                } else {
                    worldData.set("world." + String.valueOf(newWorld.getUID()) + ".autoload", true);
                }
                worldData.save();
                return this.load(name);
            }
            new Logger(this.plugin.foundryConfig).warn("Unable to create world: tried to create world but it was null when checked, something went wrong.");
            return WORLD_STATUS.OTHER_ERROR;
        }
        catch (Exception e) {
            new Logger(this.plugin.foundryConfig).warn("Unable to create world: " + e.getMessage());
            e.printStackTrace();
            return WORLD_STATUS.OTHER_ERROR;
        }
    }

    public WORLD_STATUS delete(String name) {
        List<ESSENCE_WORLD> worlds = this.list();
        for (ESSENCE_WORLD w : worlds) {
            if (!Objects.equals(name, w.name)) continue;
            if (w.status == WORLD_STATUS.LOADED) {
                return WORLD_STATUS.LOADED;
            }
            Files worldData = new Files(this.plugin.foundryConfig, this.plugin);
            String path = new File(Bukkit.getWorldContainer(), name).getPath();
            this.plugin.log.info("Path: " + String.valueOf(new File(Bukkit.getWorldContainer(), name)));
            this.plugin.log.info("Stored path: " + path);
            this.plugin.log.info("Exists: " + new File(Bukkit.getWorldContainer(), name).exists());
            if (!new File(Bukkit.getWorldContainer(), name).exists()) {
                return WORLD_STATUS.NOT_FOUND;
            }
            try {
                worldData.deleteDirectory(Path.of(path, new String[0]));
            }
            catch (IOException e) {
                this.plugin.log.warn("Exception deleting world: " + String.valueOf(e));
                return WORLD_STATUS.OTHER_ERROR;
            }
            worldData.load("data/worlds.yml");
            if (worldData.get("world." + String.valueOf(w.uuid)) != null) {
                worldData.remove("world." + String.valueOf(w.uuid));
                worldData.save();
            } else {
                worldData.close();
            }
            return WORLD_STATUS.UNLOADED;
        }
        return WORLD_STATUS.NOT_FOUND;
    }

    public WORLD_STATUS unload(String name) {
        World world = Bukkit.getWorld((String)name);
        if (world == null) {
            return WORLD_STATUS.NOT_FOUND;
        }
        if (Bukkit.unloadWorld((World)world, (boolean)true)) {
            return WORLD_STATUS.UNLOADED;
        }
        return WORLD_STATUS.OTHER_ERROR;
    }

    public WORLD_STATUS load(String name) {
        World world = Bukkit.getWorld((String)name);
        if (world == null) {
            if (new File(Bukkit.getWorldContainer(), name).exists()) {
                World loadedWorld = WorldCreator.name((String)name).createWorld();
                if (loadedWorld != null) {
                    this.saveToEssenceFile(loadedWorld, name, true, true);
                    return WORLD_STATUS.LOADED;
                }
                return WORLD_STATUS.OTHER_ERROR;
            }
            return WORLD_STATUS.NOT_FOUND;
        }
        this.saveToEssenceFile(world, name, true, true);
        return WORLD_STATUS.LOADED;
    }

    public List<ESSENCE_WORLD> list() {
        ArrayList<ESSENCE_WORLD> worlds = new ArrayList<ESSENCE_WORLD>();
        Files worldData = new Files(this.plugin.foundryConfig, this.plugin);
        worldData.load("data/worlds.yml");
        Set<String> worldList = worldData.getKeys("world", false);
        for (String w : worldList) {
            File[] folders;
            ESSENCE_WORLD world = new ESSENCE_WORLD();
            world.uuid = UUID.fromString(w);
            world.name = worldData.getString("world." + w + ".name");
            world.autoload = worldData.getBoolean("world." + w + ".autoload");
            world.status = Bukkit.getWorld((UUID)UUID.fromString(w)) != null ? WORLD_STATUS.LOADED : (Arrays.stream(folders = Bukkit.getWorldContainer().listFiles(File::isDirectory)).anyMatch(f -> f.getName().equals(world.name)) ? WORLD_STATUS.UNLOADED : WORLD_STATUS.DELETED);
            worlds.add(world);
        }
        worldData.close();
        return worlds;
    }

    public void autoloadWorlds() {
        List<ESSENCE_WORLD> list;
        List loadedWorlds = this.plugin.getServer().getWorlds();
        if (!loadedWorlds.isEmpty()) {
            this.load(((World)loadedWorlds.getFirst()).getName());
        }
        if (loadedWorlds.size() >= 2 && ((World)loadedWorlds.get(1)).getName().contains("nether")) {
            this.load(((World)loadedWorlds.get(1)).getName());
        }
        if (loadedWorlds.size() >= 3 && ((World)loadedWorlds.get(2)).getName().contains("the_end")) {
            this.load(((World)loadedWorlds.get(2)).getName());
        }
        if ((list = this.list()) != null) {
            for (ESSENCE_WORLD w : list) {
                if (!w.autoload.booleanValue() || !new File(Bukkit.getWorldContainer(), w.name).exists()) continue;
                this.load(w.name);
            }
        }
    }

    private void saveToEssenceFile(World world, String name, boolean canEnter, boolean autoload) {
        Files worldData = new Files(this.plugin.foundryConfig, this.plugin);
        worldData.load("data/worlds.yml");
        if (worldData.get("world." + String.valueOf(world.getUID())) == null) {
            worldData.set("world." + String.valueOf(world.getUID()) + ".name", name);
            worldData.set("world." + String.valueOf(world.getUID()) + ".can-enter", canEnter);
            worldData.set("world." + String.valueOf(world.getUID()) + ".autoload", autoload);
            worldData.save();
        } else {
            worldData.close();
        }
    }

    public static enum WORLD_STATUS {
        EXISTS,
        LOADED,
        UNLOADED,
        INVALID_E,
        INVALID_S,
        INVALID_T,
        INVALID_N,
        INVALID_H,
        INVALID_L,
        INVALID_A,
        OTHER_ERROR,
        INVALID_CHARS,
        NOT_FOUND,
        DELETED;

    }

    public static class ESSENCE_WORLD {
        public UUID uuid;
        public String name;
        public WORLD_STATUS status;
        public Boolean autoload;

        public String getName() {
            return this.name;
        }
    }
}

