/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.admin;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Permissions;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandInfo
extends FoundryCommand {
    private final Essence plugin;

    public CommandInfo(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.admin.info";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage message = new UtilMessage(this.plugin, cs);
        if (args.length == 1) {
            OfflinePlayer p = Bukkit.getOfflinePlayer((String)args[0]);
            if (p.hasPlayedBefore()) {
                Files fu = new Files(this.plugin.foundryConfig, this.plugin);
                if (fu.exists(fu.playerDataFile(p.getUniqueId()))) {
                    fu.load(fu.playerDataFile(p.getUniqueId()));
                    message.send("info", "uuid", new String[]{String.valueOf(p.getUniqueId())});
                    if (fu.get("user.last-known-name") != null) {
                        message.send("info", "lastname", new String[]{fu.getString("user.last-known-name")});
                    } else {
                        message.send("info", "lastname", new String[]{"Unknown"});
                    }
                    if (fu.get("user.nickname") != null) {
                        message.send("info", "nickname", new String[]{fu.getString("user.nickname")});
                    } else {
                        message.send("info", "nickname", new String[]{"None"});
                    }
                    if (fu.get("user.last-seen") != null) {
                        message.send("info", "lastseen", new String[]{fu.getString("user.last-seen")});
                    } else {
                        message.send("info", "neverseen");
                    }
                    if (new Permissions(cs).has("essence.admin.info.viewip")) {
                        if (fu.get("user.ip-address") != null) {
                            message.send("info", "ip", new String[]{fu.getString("user.ip-address")});
                        } else {
                            message.send("info", "ip", new String[]{"Unknown"});
                        }
                    } else {
                        message.send("info", "noip");
                    }
                    if (fu.get("user.team") != null) {
                        message.send("info", "team", new String[]{fu.getString("user.team")});
                    } else {
                        message.send("info", "team", new String[]{"None"});
                    }
                    fu.close();
                    if (this.plugin.flyingPlayers != null && this.plugin.flyingPlayers.contains(p.getUniqueId())) {
                        message.send("info", "canfly", new String[]{"Yes"});
                    } else {
                        message.send("info", "canfly", new String[]{"No"});
                    }
                    if (p.isOnline()) {
                        Player online = (Player)p;
                        message.send("info", "speed", new String[]{String.valueOf(online.getWalkSpeed() * 10.0f)});
                    } else {
                        message.send("info", "speed", new String[]{"Unknown whilst offline"});
                    }
                } else {
                    message.send("generic", "playernotfound");
                }
            } else {
                message.send("generic", "playernotfound");
            }
        } else {
            message.send("generic", "playernotfound");
        }
        return true;
    }
}

