/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.chat;

import java.util.ArrayList;
import java.util.List;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandIgnore
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandIgnore(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.chat.ignore";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage message = new UtilMessage(this.plugin, cs);
        Player sender = (Player)cs;
        UtilPlayer up = new UtilPlayer(this.plugin);
        if (args.length == 1) {
            for (Player playerToIgnore : Bukkit.getOnlinePlayers()) {
                if (!playerToIgnore.getName().toLowerCase().equalsIgnoreCase(args[0])) continue;
                ArrayList<String> ignoring = (ArrayList<String>)up.getPlayer(sender.getUniqueId(), UtilPlayer.KEYS.USER_IGNORING_PLAYERS);
                if (ignoring == null) {
                    ignoring = new ArrayList<String>();
                }
                if (up.playerIsIgnoring(sender.getUniqueId(), playerToIgnore.getUniqueId())) {
                    message.send("ignore", "unignored", new String[]{playerToIgnore.getName()});
                    ignoring.remove(playerToIgnore.getUniqueId().toString());
                } else {
                    message.send("ignore", "ignored", new String[]{playerToIgnore.getName()});
                    ignoring.add(playerToIgnore.getUniqueId().toString());
                }
                up.setPlayer(sender.getUniqueId(), UtilPlayer.KEYS.USER_IGNORING_PLAYERS, ignoring);
                return true;
            }
            message.send("generic", "playernotfound");
        }
        if (args.length == 0) {
            List ignoring = (List)up.getPlayer(sender.getUniqueId(), UtilPlayer.KEYS.USER_IGNORING_PLAYERS);
            if (ignoring == null || ignoring.isEmpty()) {
                message.send("ignore", "ignoringnone");
            } else {
                message.send("ignore", "ignoring", new String[]{String.join((CharSequence)",", ignoring)});
            }
        } else {
            message.send("ignore", "usage");
        }
        return true;
    }
}

