/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.chat;

import java.util.Arrays;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPlaceholder;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandReply
extends FoundryCommand {
    private final Essence plugin;

    public CommandReply(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.chat.reply";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage message = new UtilMessage(this.plugin, cs);
        if (args.length > 0) {
            if (this.plugin.msgHistory.containsKey(cs)) {
                CommandSender p = (CommandSender)this.plugin.msgHistory.get(cs);
                boolean canSend = true;
                if (!(cs instanceof ConsoleCommandSender) && cs instanceof Player) {
                    Player sender = (Player)cs;
                    if (p instanceof Player) {
                        UtilPlayer up = new UtilPlayer(this.plugin);
                        Player target = (Player)p;
                        boolean bl = canSend = !up.playerIsIgnoring(target.getUniqueId(), sender.getUniqueId());
                    }
                }
                if (canSend) {
                    String msg = String.join((CharSequence)" ", Arrays.copyOfRange(args, 0, args.length));
                    String[] repl = new String[]{cs.getName(), p.getName(), new UtilPlaceholder(this.plugin, cs).replaceAll(msg)};
                    message.send("msg", "send", repl);
                    message.sendTo(p, "msg", "send", repl);
                    if (this.plugin.msgHistory.containsKey(p)) {
                        this.plugin.msgHistory.replace(p, cs);
                    } else {
                        this.plugin.msgHistory.put(p, cs);
                    }
                } else {
                    message.send("ignore", "cantmessage", new String[]{p.getName()});
                }
            } else {
                message.send("reply", "none");
            }
            return true;
        }
        message.send("reply", "usage");
        return true;
    }
}

