/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.core;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Objects;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPlaceholderAPI;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.team.UtilTeam;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UtilPlaceholder {
    private final Essence plugin;
    private final CommandSender cs;

    public UtilPlaceholder(Essence plugin, CommandSender cs) {
        this.plugin = plugin;
        this.cs = cs;
    }

    public String replaceAll(String text) {
        if (this.plugin.integrations.PAPIEnabled) {
            if (this.cs instanceof Player) {
                return new UtilPlaceholderAPI().invokePAPI((Player)this.cs, text);
            }
            return new UtilPlaceholderAPI().invokePAPI(null, text);
        }
        text = text.replace("%essence_version%", this.replaceSingle("version"));
        text = text.replace("%essence_minecraft_version%", this.replaceSingle("minecraft_version"));
        text = text.replace("%essence_time%", this.replaceSingle("time"));
        text = text.replace("%essence_date%", this.replaceSingle("date"));
        text = text.replace("%essence_datetime%", this.replaceSingle("datetime"));
        text = text.replace("%essence_player%", this.replaceSingle("player"));
        text = text.replace("%essence_username%", this.replaceSingle("username"));
        text = text.replace("%essence_team%", this.replaceSingle("team_name"));
        text = text.replace("%essence_team_name%", this.replaceSingle("team_name"));
        text = text.replace("%essence_team_leader%", this.replaceSingle("team_leader"));
        text = text.replace("%essence_team_prefix%", this.replaceSingle("team_prefix"));
        text = text.replace("%essence_combined_prefix%", this.replaceSingle("combined_prefix"));
        text = text.replace("%essence_player_prefix%", this.replaceSingle("player_prefix"));
        text = text.replace("%essence_player_suffix%", this.replaceSingle("player_suffix"));
        text = text.replace("%essence_balance%", this.replaceSingle("balance"));
        return text;
    }

    public String replaceSingle(String placeholder) {
        UtilTeam tu = new UtilTeam(this.plugin, new UtilMessage(this.plugin, this.cs));
        if (placeholder.equalsIgnoreCase("version")) {
            return this.plugin.getDescription().getVersion();
        }
        if (placeholder.equalsIgnoreCase("minecraft_version")) {
            String mcVersion = this.plugin.getServer().getBukkitVersion();
            String[] mcVersionArray = mcVersion.split("-");
            return mcVersionArray[0];
        }
        if (placeholder.equalsIgnoreCase("time")) {
            return new SimpleDateFormat("HH:mm:ss").format(Calendar.getInstance().getTime());
        }
        if (placeholder.equalsIgnoreCase("date")) {
            return new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime());
        }
        if (placeholder.equalsIgnoreCase("datetime")) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
        }
        if (placeholder.equalsIgnoreCase("player")) {
            if (((Boolean)this.plugin.config.get("chat.manage-chat")).booleanValue()) {
                return new UtilPlayer(this.plugin).getDisplayname(this.cs);
            }
            return this.cs.getName();
        }
        if (placeholder.equalsIgnoreCase("username")) {
            return this.cs.getName();
        }
        if (placeholder.equalsIgnoreCase("team_name")) {
            CommandSender commandSender = this.cs;
            if (commandSender instanceof Player) {
                Player p = (Player)commandSender;
                return Objects.requireNonNullElse(tu.getPlayerTeam(p.getUniqueId()), "No team");
            }
            return "No team";
        }
        if (placeholder.equalsIgnoreCase("team_leader")) {
            CommandSender commandSender = this.cs;
            if (commandSender instanceof Player) {
                Player p = (Player)commandSender;
                return Objects.requireNonNullElse(tu.getTeamLeader(tu.getPlayerTeam(p.getUniqueId())), "No leader");
            }
            return "No leader";
        }
        if (placeholder.equalsIgnoreCase("team_prefix")) {
            return tu.getTeamPrefix(this.cs);
        }
        if (placeholder.equalsIgnoreCase("combined_prefix")) {
            return new UtilPlayer(this.plugin).getPlayerPrefix(this.cs) + tu.getTeamPrefix(this.cs);
        }
        if (placeholder.equalsIgnoreCase("player_prefix")) {
            return new UtilPlayer(this.plugin).getPlayerPrefix(this.cs);
        }
        if (placeholder.equalsIgnoreCase("player_suffix")) {
            return new UtilPlayer(this.plugin).getPlayerSuffix(this.cs);
        }
        if (placeholder.equalsIgnoreCase("balance")) {
            CommandSender commandSender = this.cs;
            if (commandSender instanceof Player) {
                Player p = (Player)commandSender;
                return this.plugin.config.get("economy.symbol").toString() + String.valueOf(new UtilPlayer(this.plugin).getPlayer(p.getUniqueId(), UtilPlayer.KEYS.ECONOMY_BALANCE));
            }
            return this.plugin.config.get("economy.symbol").toString() + "Infinity";
        }
        return placeholder;
    }
}

