/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.economy;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.external.Files;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class UtilVaultEconomy
implements Economy {
    private final Essence plugin;
    private final UtilPlayer up;

    public UtilVaultEconomy(Essence plugin) {
        this.plugin = plugin;
        this.up = new UtilPlayer(plugin);
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return "Essence Economy";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return -1;
    }

    public String format(double v) {
        return String.valueOf(this.plugin.config.get("economy.symbol")) + " " + v;
    }

    public String currencyNamePlural() {
        return this.currencyNameSingular();
    }

    public String currencyNameSingular() {
        return this.plugin.config.get("economy.symbol").toString();
    }

    public boolean hasAccount(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)s);
        return this.hasAccount(player);
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer) {
        Files playerData = new Files(this.plugin.foundryConfig, this.plugin);
        return playerData.exists(playerData.playerDataFile(offlinePlayer.getUniqueId()));
    }

    public boolean hasAccount(String s, String s1) {
        return this.hasAccount(s);
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer, String s) {
        return this.hasAccount(offlinePlayer);
    }

    public double getBalance(String s) {
        if (s == null || s.isEmpty()) {
            return 0.0;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)s);
        return this.getBalance(player);
    }

    public double getBalance(OfflinePlayer offlinePlayer) {
        UUID pid = Bukkit.getServer().getPlayerUniqueId(Objects.requireNonNull(offlinePlayer.getName()));
        if (this.plugin.players.containsKey(pid)) {
            this.up.savePlayer(pid);
        }
        Files fileUtil = new Files(this.plugin.foundryConfig, this.plugin);
        fileUtil.load(fileUtil.playerDataFile(offlinePlayer.getUniqueId()));
        double bal = fileUtil.getDouble("economy.balance");
        fileUtil.close();
        if (this.plugin.players.containsKey(pid)) {
            this.up.loadPlayer(pid);
        }
        return bal;
    }

    public double getBalance(String s, String s1) {
        return this.getBalance(s);
    }

    public double getBalance(OfflinePlayer offlinePlayer, String s) {
        return this.getBalance(offlinePlayer);
    }

    public boolean has(String s, double v) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)s);
        return this.has(player, v);
    }

    public boolean has(OfflinePlayer offlinePlayer, double v) {
        UUID pid = Bukkit.getServer().getPlayerUniqueId(Objects.requireNonNull(offlinePlayer.getName()));
        if (this.plugin.players.containsKey(pid)) {
            this.up.savePlayer(pid);
        }
        Files fileUtil = new Files(this.plugin.foundryConfig, this.plugin);
        fileUtil.load(fileUtil.playerDataFile(offlinePlayer.getUniqueId()));
        double bal = fileUtil.getDouble("economy.balance");
        fileUtil.close();
        if (this.plugin.players.containsKey(pid)) {
            this.up.loadPlayer(pid);
        }
        return v >= bal;
    }

    public boolean has(String s, String s1, double v) {
        return this.has(s, v);
    }

    public boolean has(OfflinePlayer offlinePlayer, String s, double v) {
        return this.has(offlinePlayer, v);
    }

    public EconomyResponse withdrawPlayer(String s, double v) {
        if (s == null || s.isEmpty()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Player name cannot be empty or null.");
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)s);
        return this.withdrawPlayer(player, v);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, double v) {
        UUID pid = Bukkit.getServer().getPlayerUniqueId(Objects.requireNonNull(offlinePlayer.getName()));
        if (this.plugin.players.containsKey(pid)) {
            this.up.savePlayer(pid);
        }
        Files fileUtil = new Files(this.plugin.foundryConfig, this.plugin);
        fileUtil.load(fileUtil.playerDataFile(offlinePlayer.getUniqueId()));
        double bal = fileUtil.getDouble("economy.balance");
        if (fileUtil.set("economy.balance", bal - v)) {
            bal = fileUtil.getDouble("economy.balance");
            fileUtil.close();
            if (this.plugin.players.containsKey(pid)) {
                this.up.loadPlayer(pid);
            }
            return new EconomyResponse(v, bal, EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(v, bal, EconomyResponse.ResponseType.FAILURE, "Unable to modify player data.");
    }

    public EconomyResponse withdrawPlayer(String s, String s1, double v) {
        return this.withdrawPlayer(s, v);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, String s, double v) {
        return this.withdrawPlayer(offlinePlayer, v);
    }

    public EconomyResponse depositPlayer(String s, double v) {
        if (s == null || s.isEmpty()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Player name cannot be empty or null.");
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)s);
        return this.depositPlayer(player, v);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, double v) {
        UUID pid = Bukkit.getServer().getPlayerUniqueId(Objects.requireNonNull(offlinePlayer.getName()));
        if (this.plugin.players.containsKey(pid)) {
            this.up.savePlayer(pid);
        }
        Files fileUtil = new Files(this.plugin.foundryConfig, this.plugin);
        fileUtil.load(fileUtil.playerDataFile(offlinePlayer.getUniqueId()));
        double bal = fileUtil.getDouble("economy.balance");
        if (fileUtil.set("economy.balance", bal + v)) {
            bal = fileUtil.getDouble("economy.balance");
            fileUtil.close();
            if (this.plugin.players.containsKey(pid)) {
                this.up.loadPlayer(pid);
            }
            return new EconomyResponse(v, bal, EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(v, bal, EconomyResponse.ResponseType.FAILURE, "Unable to modify player data.");
    }

    public EconomyResponse depositPlayer(String s, String s1, double v) {
        return this.depositPlayer(s, v);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, String s, double v) {
        return this.depositPlayer(offlinePlayer, v);
    }

    public EconomyResponse createBank(String s, String s1) {
        return this.bankNotImplemented();
    }

    public EconomyResponse createBank(String s, OfflinePlayer offlinePlayer) {
        return this.bankNotImplemented();
    }

    public EconomyResponse deleteBank(String s) {
        return this.bankNotImplemented();
    }

    public EconomyResponse bankBalance(String s) {
        return this.bankNotImplemented();
    }

    public EconomyResponse bankHas(String s, double v) {
        return this.bankNotImplemented();
    }

    public EconomyResponse bankWithdraw(String s, double v) {
        return this.bankNotImplemented();
    }

    public EconomyResponse bankDeposit(String s, double v) {
        return this.bankNotImplemented();
    }

    public EconomyResponse isBankOwner(String s, String s1) {
        return this.bankNotImplemented();
    }

    public EconomyResponse isBankOwner(String s, OfflinePlayer offlinePlayer) {
        return this.bankNotImplemented();
    }

    public EconomyResponse isBankMember(String s, String s1) {
        return this.bankNotImplemented();
    }

    public EconomyResponse isBankMember(String s, OfflinePlayer offlinePlayer) {
        return this.bankNotImplemented();
    }

    public List<String> getBanks() {
        return Collections.emptyList();
    }

    public boolean createPlayerAccount(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)s);
        return this.createPlayerAccount(player);
    }

    public boolean createPlayerAccount(OfflinePlayer p) {
        UtilPlayer up = new UtilPlayer(this.plugin);
        return up.createPlayer(p.getUniqueId());
    }

    public boolean createPlayerAccount(String s, String s1) {
        return this.createPlayerAccount(s);
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer, String s) {
        return this.createPlayerAccount(offlinePlayer);
    }

    public EconomyResponse bankNotImplemented() {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Essence does not support bank accounts, please consider using another economy provider if you require this feature.");
    }
}

