/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.environment;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.environment.UtilEnvironment;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandPWeather
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandPWeather(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.environment.pweather";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        Player p = (Player)cs;
        UtilEnvironment env = new UtilEnvironment((Plugin)this.plugin);
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        if (args.length == 0) {
            msg.send("environment", "playerweather", new String[]{env.getPlayerWeather(p).toString()});
        } else if (args.length == 1) {
            if (new UtilPermission(this.plugin, cs).has("essence.environment.pweather.set")) {
                if (args[0].equalsIgnoreCase("clear") || args[0].equalsIgnoreCase("sun") || args[0].equalsIgnoreCase("sunny")) {
                    env.setPlayerWeather(p, UtilEnvironment.Weather.CLEAR);
                } else if (args[0].equalsIgnoreCase("rain") || args[0].equalsIgnoreCase("raining") || args[0].equalsIgnoreCase("downpour")) {
                    env.setPlayerWeather(p, UtilEnvironment.Weather.RAIN);
                } else if (args[0].equalsIgnoreCase("thunder") || args[0].equalsIgnoreCase("lightning") || args[0].equalsIgnoreCase("storm")) {
                    env.setPlayerWeather(p, UtilEnvironment.Weather.THUNDER);
                } else {
                    if (args[0].equalsIgnoreCase("reset") || args[0].equalsIgnoreCase("off")) {
                        env.setPlayerWeather(p, UtilEnvironment.Weather.RESET);
                        msg.send("environment", "playerweatherreset");
                        return true;
                    }
                    msg.send("generic", "unknownweather", new String[]{args[0]});
                    return true;
                }
                msg.send("environment", "playerweatherset", new String[]{env.getPlayerWeather(p).toString()});
            } else {
                new UtilPermission(this.plugin, cs).not();
            }
        }
        return true;
    }
}

