/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.external;

import org.bukkit.plugin.java.JavaPlugin;

public class Version {
    private final JavaPlugin plugin;

    public Version(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public String getFoundryVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String getServerVersion() {
        return this.plugin.getServer().getBukkitVersion();
    }

    public boolean serverIsAtLeast(String version) {
        return this.isEqualTo(this.getServerVersion(), version) || this.isNewerThan(this.getServerVersion(), version);
    }

    public boolean isNewerThan(String version1, String version2) {
        if (version1 == null || version2 == null) {
            return false;
        }
        String cleanVersion1 = version1.split("-")[0];
        String cleanVersion2 = version2.split("-")[0];
        String[] parts1 = cleanVersion1.split("\\.");
        String[] parts2 = cleanVersion2.split("\\.");
        int maxLength = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < maxLength; ++i) {
            int part2;
            int part1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = part2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (part1 > part2) {
                return true;
            }
            if (part1 >= part2) continue;
            return false;
        }
        return false;
    }

    public boolean isEqualTo(String version1, String version2) {
        if (version1 == null || version2 == null) {
            return false;
        }
        String cleanVersion1 = version1.split("-")[0];
        String cleanVersion2 = version2.split("-")[0];
        String[] parts1 = cleanVersion1.split("\\.");
        String[] parts2 = cleanVersion2.split("\\.");
        int maxLength = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < maxLength; ++i) {
            int part2;
            int part1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = part2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (part1 == part2) continue;
            return false;
        }
        return true;
    }
}

