/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.inventory;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class CommandSkull
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandSkull(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.inventory.skull";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        if (!(cs instanceof Player)) {
            msg.send("generic", "playernotfound");
            return true;
        }
        Player player = (Player)cs;
        if (args.length < 1) {
            msg.send("skull", "usage");
            return true;
        }
        String targetName = args[0];
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((String)targetName));
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + targetName + "'s Head");
            skull.setItemMeta((ItemMeta)meta);
        }
        player.getInventory().addItem(new ItemStack[]{skull});
        msg.send("skull", "given", new String[]{targetName});
        return true;
    }
}

