/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.stats;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandExtinguish
extends FoundryCommand {
    private final Essence plugin;

    public CommandExtinguish(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.stats.extinguish";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage message = new UtilMessage(this.plugin, cs);
        if (args.length > 0) {
            return this.extinguishOther(new UtilPermission(this.plugin, cs), cs, message, args);
        }
        if (!(cs instanceof Player)) {
            message.send("extinguish", "usage");
            return true;
        }
        return this.extinguishSelf(cs, message);
    }

    private void extinguishPlayer(Player player) {
        player.setFireTicks(0);
    }

    private boolean extinguishSelf(CommandSender sender, UtilMessage message) {
        Player player = (Player)sender;
        this.extinguishPlayer(player);
        message.send("extinguish", "beenextinguished");
        return true;
    }

    private boolean extinguishOther(UtilPermission permission, CommandSender sender, UtilMessage message, String[] args) {
        if (permission.has("essence.stats.extinguish.other")) {
            String pName = args[0];
            Player p = Bukkit.getPlayer((String)pName);
            if (p != null) {
                message.send("extinguish", "extinguished", new String[]{p.getName()});
                if (!(sender instanceof Player)) {
                    message.sendTo((CommandSender)p, "extinguish", "serverextinguished");
                } else {
                    message.sendTo((CommandSender)p, "extinguish", "extinguishedby", new String[]{sender.getName()});
                }
                this.extinguishPlayer(p);
            } else {
                message.send("generic", "playernotfound");
            }
            return true;
        }
        return permission.not();
    }
}

