/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandAscend
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandAscend(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.teleport.ascend";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        int levels = 1;
        if (args.length > 0) {
            try {
                levels = Integer.parseInt(args[0]);
                if (levels <= 0) {
                    msg.send("ascend", "invalidnumber", new String[]{args[0]});
                    return true;
                }
                return this.ascend((Player)cs, levels, msg);
            }
            catch (NumberFormatException e) {
                msg.send("ascend", "invalidnumber", new String[]{args[0]});
                return true;
            }
        }
        return this.ascend((Player)cs, levels, msg);
    }

    private boolean ascend(Player cs, Integer levels, UtilMessage msg) {
        int waitTime;
        UtilTeleport.LevelLocation result = UtilTeleport.findLevelLocation(cs.getLocation(), UtilTeleport.Direction.UP, levels, cs);
        if (result == null) {
            msg.send("ascend", "nosafelocation");
            return true;
        }
        Location ascendLocation = result.location();
        int finalLevels = result.finalLevels();
        int n = waitTime = this.plugin.config.get("teleportation.ascend.wait") != null ? (Integer)this.plugin.config.get("teleportation.ascend.wait") : 0;
        if (ascendLocation == null) {
            msg.send("ascend", "nosafelocation");
            return true;
        }
        new UtilTeleport(this.plugin).doTeleport(cs, ascendLocation, waitTime, true);
        if (waitTime == 0) {
            msg.send("ascend", "going", new String[]{String.valueOf(finalLevels)});
            return true;
        }
        return true;
    }
}

