/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.tp;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.command.FoundryCommand;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandTeleport
extends FoundryCommand {
    private final Essence plugin;

    public CommandTeleport(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return null;
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage message = new UtilMessage(this.plugin, cs);
        Player player = null;
        if (!this.console(cs)) {
            player = (Player)cs;
        }
        UtilPermission permission = new UtilPermission(this.plugin, cs);
        if (args.length == 0) {
            message.send("teleport", "usage");
            return true;
        }
        UtilTeleport tp = new UtilTeleport(this.plugin);
        if (args.length >= 4) {
            double z;
            double y;
            double x;
            boolean isSelf;
            boolean bl = isSelf = cs instanceof Player && (args[0].equalsIgnoreCase("@s") || args[0].equalsIgnoreCase(cs.getName()));
            if (isSelf ? !permission.has("essence.teleport.coord") : !permission.has("essence.teleport.other") || !permission.has("essence.teleport.coord")) {
                return permission.not();
            }
            String selector = args[0];
            List<Player> targets = this.parseSelector(selector, cs);
            if (targets.isEmpty()) {
                message.send("generic", "playernotfound");
                return true;
            }
            try {
                Player ref;
                Player player2 = ref = cs instanceof Player ? (Player)cs : targets.getFirst();
                double d = args[1].startsWith("~") ? (args[1].length() == 1 ? ref.getLocation().getX() : ref.getLocation().getX() + Double.parseDouble(args[1].substring(1))) : (x = Double.parseDouble(args[1]));
                double d2 = args[2].startsWith("~") ? (args[2].length() == 1 ? ref.getLocation().getY() : ref.getLocation().getY() + Double.parseDouble(args[2].substring(1))) : (y = Double.parseDouble(args[2]));
                z = args[3].startsWith("~") ? (args[3].length() == 1 ? ref.getLocation().getZ() : ref.getLocation().getZ() + Double.parseDouble(args[3].substring(1))) : Double.parseDouble(args[3]);
            }
            catch (Exception e) {
                message.send("generic", "numberformaterror");
                return true;
            }
            for (Player t : targets) {
                if (!tp.teleportToggleCheck(player, t)) {
                    message.send("teleport", "requestsdisabled", new String[]{t.getName()});
                    continue;
                }
                Location loc = new Location(t.getWorld(), x, y, z);
                tp.doTeleport(t, loc, 0, true);
            }
            message.send("teleport", "tocoord", new String[]{String.format("%.1f, %.1f, %.1f", x, y, z)});
            return true;
        }
        if (args.length == 2) {
            if (!permission.has("essence.teleport.other") || !permission.has("essence.teleport.player")) {
                return permission.not();
            }
            List<Player> fromList = this.parseSelector(args[0], cs);
            List<Player> toList = this.parseSelector(args[1], cs);
            if (fromList.isEmpty() || toList.isEmpty()) {
                message.send("generic", "playernotfound");
                return true;
            }
            Player to = toList.getFirst();
            for (Player from : fromList) {
                if (!tp.teleportToggleCheck(player, to)) {
                    message.send("teleport", "requestsdisabled", new String[]{to.getName()});
                    continue;
                }
                tp.doTeleport(from, to.getLocation(), 0, true);
            }
            message.send("teleport", "toplayer", new String[]{fromList.stream().map(Player::getName).collect(Collectors.joining(", ")), to.getName()});
            return true;
        }
        if (args.length == 3 && player != null) {
            double z;
            double y;
            double x;
            if (!permission.has("essence.teleport.coord")) {
                return permission.not();
            }
            try {
                double d = args[0].startsWith("~") ? (args[0].length() == 1 ? player.getLocation().getX() : player.getLocation().getX() + Double.parseDouble(args[0].substring(1))) : (x = Double.parseDouble(args[0]));
                double d3 = args[1].startsWith("~") ? (args[1].length() == 1 ? player.getLocation().getY() : player.getLocation().getY() + Double.parseDouble(args[1].substring(1))) : (y = Double.parseDouble(args[1]));
                z = args[2].startsWith("~") ? (args[2].length() == 1 ? player.getLocation().getZ() : player.getLocation().getZ() + Double.parseDouble(args[2].substring(1))) : Double.parseDouble(args[2]);
            }
            catch (Exception e) {
                message.send("generic", "numberformaterror");
                return true;
            }
            Location loc = new Location(player.getWorld(), x, y, z);
            tp.doTeleport(player, loc, 0, true);
            message.send("teleport", "tocoord", new String[]{String.format("%.1f, %.1f, %.1f", x, y, z)});
            return true;
        }
        if (args.length == 1 && player != null) {
            OfflinePlayer offline;
            if (!permission.has("essence.teleport.player")) {
                return permission.not();
            }
            List<Player> toList = this.parseSelector(args[0], cs);
            if (!toList.isEmpty()) {
                Player to = toList.getFirst();
                if (!tp.teleportToggleCheck(player, to)) {
                    message.send("teleport", "requestsdisabled", new String[]{to.getName()});
                    return true;
                }
                tp.doTeleport(player, to.getLocation(), 0, true);
                message.send("teleport", "to", new String[]{to.getName()});
                return true;
            }
            if (!permission.has("essence.teleport.offline") && (offline = this.getOfflinePlayer(args[0])) != null && offline.hasPlayedBefore()) {
                Files opf = new Files(this.plugin.foundryConfig, this.plugin);
                if (opf.exists(opf.playerDataFile(offline.getUniqueId()))) {
                    opf.load(opf.playerDataFile(offline.getUniqueId()));
                    double x = opf.getDouble("last-location.X");
                    double y = opf.getDouble("last-location.Y");
                    double z = opf.getDouble("last-location.Z");
                    World world = Bukkit.getWorld((String)opf.getString("last-location.world"));
                    opf.close();
                    if (world == null) {
                        message.send("teleport", "offlinenoworld");
                        return true;
                    }
                    Location offlineLoc = new Location(world, x, y, z);
                    tp.doTeleport(player, offlineLoc, 0, true);
                    message.send("teleport", "to", new String[]{offline.getName()});
                    message.send("teleport", "tooffline");
                    return true;
                }
                message.send("teleport", "offlineplayernodata");
                return true;
            }
            message.send("generic", "playernotfound");
            return true;
        }
        message.send("teleport", "usage");
        return true;
    }

    public boolean console(CommandSender commandSender) {
        return !(commandSender instanceof Player);
    }

    private List<Player> parseSelector(String selector, CommandSender sender) {
        if (selector.equalsIgnoreCase("@s")) {
            if (sender instanceof Player) {
                ArrayList<Player> list = new ArrayList<Player>();
                list.add((Player)sender);
                return list;
            }
            return new ArrayList<Player>();
        }
        if (selector.equalsIgnoreCase("@a")) {
            return new ArrayList<Player>(Bukkit.getOnlinePlayers());
        }
        if (selector.equalsIgnoreCase("@p")) {
            if (sender instanceof Player) {
                Player self = (Player)sender;
                Player nearest = null;
                double minDist = Double.MAX_VALUE;
                for (Player p : Bukkit.getOnlinePlayers()) {
                    double dist;
                    if (p.equals((Object)self) || !((dist = p.getLocation().distance(self.getLocation())) < minDist)) continue;
                    minDist = dist;
                    nearest = p;
                }
                if (nearest != null) {
                    ArrayList<Player> list = new ArrayList<Player>();
                    list.add(nearest);
                    return list;
                }
            }
            return new ArrayList<Player>();
        }
        Player p = this.plugin.getServer().getPlayer(selector);
        if (p != null) {
            ArrayList<Player> list = new ArrayList<Player>();
            list.add(p);
            return list;
        }
        return new ArrayList<Player>();
    }

    private OfflinePlayer getOfflinePlayer(String name) {
        for (OfflinePlayer op : Bukkit.getOfflinePlayers()) {
            if (op.getName() == null || !op.getName().equalsIgnoreCase(name)) continue;
            return op;
        }
        return null;
    }
}

