/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.tp;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Logger;
import net.lewmc.essence.external.folialib.FoliaLib;
import net.lewmc.essence.teleportation.UtilLocation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UtilTeleport {
    private final Essence plugin;
    private final Logger log;

    public UtilTeleport(Essence plugin) {
        this.plugin = plugin;
        this.log = new Logger(plugin.foundryConfig);
    }

    public boolean cooldownSurpassed(Player player, String type) {
        LocalDateTime lastEvent;
        UtilPermission perms = new UtilPermission(this.plugin, (CommandSender)player);
        if (perms.has("essence.bypass.teleportcooldown")) {
            return true;
        }
        int cooldown = (Integer)this.plugin.config.get("teleportation." + type + ".cooldown");
        if (cooldown < 0) {
            return true;
        }
        Files data = new Files(this.plugin.foundryConfig, this.plugin);
        data.load(data.playerDataFile(player));
        if (data.get("cooldown." + type) == null) {
            return true;
        }
        String last = data.getString("cooldown." + type);
        if (last == null) {
            return true;
        }
        data.close();
        try {
            lastEvent = LocalDateTime.parse(last);
        }
        catch (DateTimeException e) {
            this.log.warn("DateTimeException: " + String.valueOf(e));
            this.log.warn("Unable to calculate cooldown, the field may be missing or corrupted. Resetting...");
            return true;
        }
        LocalDateTime currentTime = LocalDateTime.now();
        Duration timeElapsed = Duration.between(lastEvent, currentTime);
        return timeElapsed.getSeconds() >= (long)cooldown;
    }

    public void setCooldown(Player player, String type) {
        Files data = new Files(this.plugin.foundryConfig, this.plugin);
        data.load(data.playerDataFile(player));
        LocalDateTime currentTime = LocalDateTime.now();
        data.set("cooldown." + type, currentTime.toString());
        data.save();
    }

    public int cooldownRemaining(Player player, String type) {
        LocalDateTime lastEvent;
        UtilPermission perms = new UtilPermission(this.plugin, (CommandSender)player);
        if (perms.has("essence.bypass.teleportcooldown")) {
            return 0;
        }
        int cooldown = (Integer)this.plugin.config.get("teleportation." + type + ".cooldown");
        if (cooldown <= 0) {
            return 0;
        }
        Files data = new Files(this.plugin.foundryConfig, this.plugin);
        data.load(data.playerDataFile(player));
        if (data.getString("cooldown." + type) == null) {
            return 0;
        }
        String last = data.getString("cooldown." + type);
        data.close();
        try {
            lastEvent = LocalDateTime.parse(Objects.requireNonNull(last));
        }
        catch (DateTimeException e) {
            this.log.warn("DateTimeException: " + String.valueOf(e));
            this.log.warn("Unable to calculate cooldown, the field may be missing or corrupted.");
            return 0;
        }
        LocalDateTime currentTime = LocalDateTime.now();
        Duration timeElapsed = Duration.between(lastEvent, currentTime);
        return Math.toIntExact(Math.max(0L, (long)cooldown - timeElapsed.getSeconds()));
    }

    public void doTeleport(Player player, World world, double X, double Y, double Z, float yaw, float pitch, int delay, boolean doLastLocUpdate) {
        Location loc = new Location(world, X, Y, Z, yaw, pitch);
        UtilPermission perms = new UtilPermission(this.plugin, (CommandSender)player);
        if (perms.has("essence.bypass.teleportdelay")) {
            delay = 0;
        }
        this.doTeleport(player, loc, delay, doLastLocUpdate);
    }

    public void doTeleport(final Player player, final Location location, int delay, final boolean doLastLocUpdate) {
        World currentWorld;
        FoliaLib flib = new FoliaLib((Plugin)this.plugin);
        UtilMessage message = new UtilMessage(this.plugin, (CommandSender)player);
        if (location.getWorld() == null) {
            message.send("teleport", "exception");
            this.log.severe("Unable to locate world in universe.");
            this.log.severe("Details: {\"error\": \"WORLD_IS_NULL\", \"caught\": \"TeleportUtil.java\", \"submitted\": \"null\", \"found\": \"null\"}.");
            this.log.severe("Location: " + String.valueOf(location));
            return;
        }
        World targetWorld = location.getWorld();
        if (!targetWorld.equals((Object)(currentWorld = player.getWorld())) && !targetWorld.getName().equals(location.getWorld().getName())) {
            message.send("teleport", "exception");
            this.log.severe("World mismatch detected during cross-world teleportation.");
            this.log.severe("Details: {\"error\": \"WORLD_MISMATCH\", \"player\": \"" + player.getName() + "\", \"from\": \"" + currentWorld.getName() + "\", \"to\": \"" + targetWorld.getName() + "\"}.");
            return;
        }
        if (delay > 0 && ((Boolean)this.plugin.config.get("teleportation.move-to-cancel")).booleanValue()) {
            message.send("teleport", "movetocancel");
        }
        this.setTeleportStatus(player, true);
        if (flib.isFolia()) {
            long delayTicks = Math.max(1L, (long)delay * 20L);
            flib.getImpl().runAtEntityLater((Entity)player, () -> {
                if (this.teleportIsValid(player)) {
                    if (doLastLocUpdate) {
                        new UtilLocation(this.plugin).UpdateLastLocation(player);
                    }
                    player.teleportAsync(location);
                    this.setTeleportStatus(player, false);
                }
            }, delayTicks);
        } else {
            new BukkitRunnable(){

                public void run() {
                    if (UtilTeleport.this.teleportIsValid(player)) {
                        if (doLastLocUpdate) {
                            new UtilLocation(UtilTeleport.this.plugin).UpdateLastLocation(player);
                        }
                        player.teleport(location);
                        UtilTeleport.this.setTeleportStatus(player, false);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)delay * 20L);
        }
    }

    public void setTeleportStatus(Player player, boolean teleportInFuture) {
        if (teleportInFuture) {
            this.plugin.teleportingPlayers.add(player.getUniqueId());
        } else {
            this.plugin.teleportingPlayers.remove(player.getUniqueId());
        }
    }

    public boolean teleportIsValid(Player player) {
        if (this.plugin.teleportingPlayers == null) {
            return false;
        }
        return this.plugin.teleportingPlayers.contains(player.getUniqueId());
    }

    public boolean teleportToggleCheck(Player requester, Player target) {
        Files targetPd = new Files(this.plugin.foundryConfig, this.plugin);
        targetPd.load(targetPd.playerDataFile(target));
        Files config = new Files(this.plugin.foundryConfig, this.plugin);
        config.load("config.yml");
        UtilPermission ph = new UtilPermission(this.plugin, (CommandSender)requester);
        if (!targetPd.getBoolean("user.accepting-teleport-requests") && config.getBoolean("teleportation.extended-toggle") && !ph.has("essence.bypass.extendedteleporttoggle")) {
            targetPd.close();
            config.close();
            return false;
        }
        targetPd.close();
        config.close();
        return true;
    }

    public static Location findFurthestLocation(Location origin, Direction direction, Player player) {
        int step;
        int endY;
        int startY;
        if (origin == null) {
            return null;
        }
        World world = origin.getWorld();
        if (world == null) {
            return null;
        }
        int x = origin.getBlockX();
        int z = origin.getBlockZ();
        float yaw = origin.getYaw();
        float pitch = origin.getPitch();
        if (direction == Direction.UP) {
            startY = world.getMaxHeight() + 1;
            endY = world.getMinHeight();
            step = -1;
        } else {
            startY = world.getMinHeight();
            endY = world.getMaxHeight();
            step = 1;
        }
        int y = startY;
        while (direction == Direction.UP == y >= endY) {
            Block below;
            Block feet = world.getBlockAt(x, y, z);
            Block head = y < world.getMaxHeight() + 1 ? world.getBlockAt(x, y + 1, z) : null;
            Block block = below = y > world.getMinHeight() ? world.getBlockAt(x, y - 1, z) : null;
            if (UtilTeleport.isSafeLocation(feet, head, below, player)) {
                return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5, yaw, pitch);
            }
            y += step;
        }
        return null;
    }

    public static LevelLocation findLevelLocation(Location origin, Direction direction, Integer levels, Player player) {
        if (origin == null) {
            return null;
        }
        World world = origin.getWorld();
        if (world == null) {
            return null;
        }
        int x = origin.getBlockX();
        int z = origin.getBlockZ();
        int y = origin.getBlockY();
        float yaw = origin.getYaw();
        float pitch = origin.getPitch();
        int step = direction == Direction.UP ? 1 : -1;
        int currentLevel = 0;
        Location lastSafeLocation = null;
        for (int currentY = y + step; currentY >= world.getMinHeight() && currentY <= world.getMaxHeight(); currentY += step) {
            Block below;
            Block feet = world.getBlockAt(x, currentY, z);
            Block head = currentY < world.getMaxHeight() + 1 ? world.getBlockAt(x, currentY + 1, z) : null;
            Block block = below = currentY > world.getMinHeight() ? world.getBlockAt(x, currentY - 1, z) : null;
            if (!UtilTeleport.isSafeLocation(feet, head, below, player)) continue;
            lastSafeLocation = new Location(world, (double)x + 0.5, (double)currentY, (double)z + 0.5, yaw, pitch);
            if (++currentLevel == levels) {
                return new LevelLocation(lastSafeLocation, currentLevel);
            }
            currentY += step;
        }
        return new LevelLocation(lastSafeLocation, currentLevel);
    }

    private static boolean isSafeLocation(Block feet, Block head, Block below, Player player) {
        return !(head == null || head.isLiquid() && !player.isInvulnerable() || !head.isPassable() || feet == null || feet.isLiquid() && !player.isInvulnerable() || !feet.isPassable() || below == null || below.getType().isAir() || !below.getType().isSolid());
    }

    public void sendToSpawn(Player player, String spawnName) {
        Files spawnConfiguration = new Files(this.plugin.foundryConfig, this.plugin);
        if (!spawnConfiguration.load("data/worlds.yml")) {
            this.plugin.log.severe("Unable to load configuration file 'data/spawns.yml'. Essence may be unable to teleport players to the correct spawn");
            return;
        }
        World spawnWorld = Bukkit.getServer().getWorld(spawnName);
        if (spawnWorld == null) {
            this.plugin.log.severe("The spawn world does not exist. Please check your Essence configuration.");
            return;
        }
        if (spawnConfiguration.get("world." + String.valueOf(spawnWorld.getUID()) + ".spawn") == null) {
            if (Bukkit.getServer().getWorld(spawnName).getSpawnLocation() != null) {
                UtilTeleport tp = new UtilTeleport(this.plugin);
                tp.doTeleport(player, spawnWorld, spawnWorld.getSpawnLocation().getX(), spawnWorld.getSpawnLocation().getY(), spawnWorld.getSpawnLocation().getZ(), spawnWorld.getSpawnLocation().getYaw(), spawnWorld.getSpawnLocation().getPitch(), 0, true);
            } else {
                this.plugin.log.info("Failed to respawn player - world spawn for '" + String.valueOf(spawnWorld) + "' does not exist.");
            }
        } else {
            UtilTeleport tp = new UtilTeleport(this.plugin);
            tp.doTeleport(player, spawnWorld, spawnConfiguration.getDouble("world." + String.valueOf(spawnWorld.getUID()) + ".spawn.x"), spawnConfiguration.getDouble("world." + String.valueOf(spawnWorld.getUID()) + ".spawn.y"), spawnConfiguration.getDouble("world." + String.valueOf(spawnWorld.getUID()) + ".spawn.z"), (float)spawnConfiguration.getDouble("world." + String.valueOf(spawnWorld.getUID()) + ".spawn.yaw"), (float)spawnConfiguration.getDouble("world." + String.valueOf(spawnWorld.getUID()) + ".spawn.pitch"), 0, true);
        }
        spawnConfiguration.close();
    }

    public static enum Direction {
        UP,
        DOWN;

    }

    public record LevelLocation(Location location, int finalLevels) {
    }
}

