/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.warp;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Security;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.teleportation.warp.UtilWarp;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandSetwarp
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandSetwarp(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.warp.create";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        Player p = (Player)cs;
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        if (args.length == 0) {
            msg.send("warp", "setusage");
            return true;
        }
        Location loc = p.getLocation();
        Files warpsData = new Files(this.plugin.foundryConfig, this.plugin);
        warpsData.load("data/warps.yml");
        String warpName = args[0].toLowerCase();
        if (new Security(this.plugin.foundryConfig).hasSpecialCharacters(warpName)) {
            warpsData.close();
            msg.send("warp", "specialchars");
            return true;
        }
        UtilWarp wu = new UtilWarp(this.plugin);
        int warpLimit = new UtilPermission(this.plugin, cs).getWarpsLimit(p);
        if (wu.getWarpCount(p) >= warpLimit && warpLimit != -1) {
            msg.send("warp", "hitlimit");
            return true;
        }
        if (wu.create(warpName, p.getUniqueId(), loc)) {
            msg.send("warp", "created", new String[]{args[0]});
        } else {
            msg.send("warp", "cantcreate", new String[]{args[0]});
        }
        warpsData.close();
        return true;
    }
}

