/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.warp;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Logger;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandWarp
extends FoundryPlayerCommand {
    private final Essence plugin;
    private final Logger log;

    public CommandWarp(Essence plugin) {
        this.plugin = plugin;
        this.log = new Logger(plugin.foundryConfig);
    }

    @Override
    protected String requiredPermission() {
        return "essence.warp.use";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        Player p = (Player)cs;
        int waitTime = (Integer)this.plugin.config.get("teleportation.warp.wait");
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        if (args.length > 0) {
            UtilTeleport teleUtil = new UtilTeleport(this.plugin);
            if (!teleUtil.cooldownSurpassed(p, "warp")) {
                msg.send("teleport", "tryagain", new String[]{String.valueOf(teleUtil.cooldownRemaining(p, "warp"))});
                return true;
            }
            Files config = new Files(this.plugin.foundryConfig, this.plugin);
            config.load("data/warps.yml");
            if (config.get("warps." + args[0].toLowerCase()) == null) {
                msg.send("warp", "notfound", new String[]{args[0].toLowerCase()});
                return true;
            }
            if (config.getString("warps." + args[0].toLowerCase() + ".world") == null) {
                config.close();
                msg.send("generic", "exception");
                this.log.warn("Player " + String.valueOf(p) + " attempted to warp to " + args[0].toLowerCase() + " but couldn't due to an error.");
                this.log.warn("Error: world is null, please check configuration file.");
                return true;
            }
            teleUtil.setCooldown(p, "warp");
            World world = Bukkit.getServer().getWorld(config.getString("warps." + args[0].toLowerCase() + ".world"));
            if (world == null) {
                msg.send("generic", "exception");
                this.log.warn("Player " + String.valueOf(p) + " attempted to warp to " + args[0].toLowerCase() + " but couldn't due to an error.");
                this.log.warn("Error: world is null, please check configuration file.");
            }
            if (waitTime > 0) {
                msg.send("warp", "teleportingin", new String[]{args[0], "" + waitTime});
            } else {
                msg.send("warp", "teleportingnow", new String[]{args[0]});
            }
            teleUtil.doTeleport(p, world, config.getDouble("warps." + args[0].toLowerCase() + ".X"), config.getDouble("warps." + args[0].toLowerCase() + ".Y"), config.getDouble("warps." + args[0].toLowerCase() + ".Z"), (float)config.getDouble("warps." + args[0].toLowerCase() + ".yaw"), (float)config.getDouble("warps." + args[0].toLowerCase() + ".pitch"), waitTime, true);
            config.close();
            return true;
        }
        msg.send("warp", "usage");
        return true;
    }
}

