/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.core;

import java.util.List;
import java.util.Set;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Permissions;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class UtilPermission {
    private final CommandSender cs;
    private final Essence plugin;

    public UtilPermission(Essence plugin, CommandSender cs) {
        this.plugin = plugin;
        this.cs = cs;
    }

    public boolean has(String node) {
        return new Permissions(this.cs).has(node);
    }

    public boolean not() {
        new UtilMessage(this.plugin, this.cs).send("generic", "missingpermission");
        return true;
    }

    public int getHomesLimit(Player player) {
        return this.getLimit(player, "home");
    }

    public int getTeamHomesLimit(Player player) {
        return this.getLimit(player, "home.team");
    }

    public int getWarpsLimit(Player player) {
        return this.getLimit(player, "warp");
    }

    private int getLimit(Player player, String type) {
        Set perms = player.getEffectivePermissions();
        for (PermissionAttachmentInfo i : perms) {
            if (!i.getPermission().contains("essence." + type + ".limit")) continue;
            String[] vars = i.getPermission().split("\\.");
            return Integer.parseInt(vars[vars.length - 1]);
        }
        return -1;
    }

    public boolean itemIsBlacklisted(String item) {
        Files config = new Files(this.plugin.foundryConfig, this.plugin);
        config.load("config.yml");
        List<String> blacklist = config.getStringList("item-blacklist");
        for (String s : blacklist) {
            if (!s.equalsIgnoreCase(item)) continue;
            return true;
        }
        return false;
    }
}

