/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.environment;

import net.lewmc.essence.external.folialib.FoliaLib;
import org.bukkit.Bukkit;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UtilEnvironment {
    private final Plugin plugin;

    public UtilEnvironment(Plugin plugin) {
        this.plugin = plugin;
    }

    public Weather getWeather(World w) {
        if (w != null) {
            if (w.isClearWeather()) {
                return Weather.CLEAR;
            }
            if (w.isThundering()) {
                return Weather.THUNDER;
            }
            if (w.hasStorm()) {
                return Weather.RAIN;
            }
            return Weather.UNKNOWN;
        }
        return Weather.UNKNOWN;
    }

    public boolean setWeather(World wo, Weather we) {
        if (wo != null) {
            if (we == Weather.CLEAR) {
                wo.setStorm(false);
                wo.setThundering(false);
                return true;
            }
            if (we == Weather.RAIN) {
                wo.setThundering(false);
                wo.setStorm(true);
                return true;
            }
            if (we == Weather.THUNDER) {
                wo.setStorm(false);
                wo.setThundering(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public Weather getPlayerWeather(Player p) {
        if (p != null) {
            if (p.getPlayerWeather() == WeatherType.CLEAR) {
                return Weather.CLEAR;
            }
            if (p.getPlayerWeather() == WeatherType.DOWNFALL) {
                return Weather.RAIN;
            }
            return Weather.UNKNOWN;
        }
        return Weather.UNKNOWN;
    }

    public boolean setPlayerWeather(Player p, Weather we) {
        if (p != null) {
            if (we == Weather.CLEAR) {
                p.setPlayerWeather(WeatherType.CLEAR);
            } else if (we == Weather.RAIN) {
                p.setPlayerWeather(WeatherType.DOWNFALL);
            } else if (we == Weather.THUNDER) {
                p.setPlayerWeather(WeatherType.DOWNFALL);
            } else if (we == Weather.RESET) {
                p.resetPlayerWeather();
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public long getTime(World w) {
        if (w != null) {
            return w.getTime();
        }
        return -1L;
    }

    public boolean setTime(World wo, Time t) {
        if (wo != null) {
            if (t == Time.DAY) {
                return this.setTime(wo, 1000L);
            }
            if (t == Time.MIDDAY) {
                return this.setTime(wo, 6000L);
            }
            if (t == Time.EVENING) {
                return this.setTime(wo, 10000L);
            }
            if (t == Time.SUNSET) {
                return this.setTime(wo, 12000L);
            }
            if (t == Time.NIGHT) {
                return this.setTime(wo, 13000L);
            }
            if (t == Time.MIDNIGHT) {
                return this.setTime(wo, 18000L);
            }
            if (t == Time.SUNRISE) {
                return this.setTime(wo, 23000L);
            }
            return false;
        }
        return false;
    }

    public boolean setTime(World wo, long t) {
        if (wo != null) {
            Plugin pluginInstance = this.getPlugin();
            if (pluginInstance != null) {
                FoliaLib flib = new FoliaLib(pluginInstance);
                if (flib.isFolia()) {
                    flib.getImpl().runNextTick(task -> wo.setTime(t));
                } else {
                    wo.setTime(t);
                }
            } else {
                wo.setTime(t);
            }
            return true;
        }
        return false;
    }

    private Plugin getPlugin() {
        Plugin[] plugins;
        if (this.plugin != null) {
            return this.plugin;
        }
        for (Plugin plugin : plugins = Bukkit.getPluginManager().getPlugins()) {
            if (!plugin.getName().equals("Essence")) continue;
            return plugin;
        }
        return plugins.length > 0 ? plugins[0] : null;
    }

    public long getPlayerTime(Player p) {
        if (p != null) {
            return p.getPlayerTime();
        }
        return -1L;
    }

    public boolean setPlayerTime(Player p, Time t) {
        if (p != null) {
            if (t == Time.DAY) {
                return this.setPlayerTime(p, 1000L);
            }
            if (t == Time.MIDDAY) {
                return this.setPlayerTime(p, 6000L);
            }
            if (t == Time.EVENING) {
                return this.setPlayerTime(p, 10000L);
            }
            if (t == Time.SUNSET) {
                return this.setPlayerTime(p, 12000L);
            }
            if (t == Time.NIGHT) {
                return this.setPlayerTime(p, 13000L);
            }
            if (t == Time.MIDNIGHT) {
                return this.setPlayerTime(p, 18000L);
            }
            if (t == Time.SUNRISE) {
                return this.setPlayerTime(p, 23000L);
            }
            if (t == Time.RESET) {
                p.resetPlayerTime();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean setPlayerTime(Player p, long t) {
        if (p != null) {
            p.setPlayerTime(t, true);
            return true;
        }
        return false;
    }

    public static enum Weather {
        CLEAR{

            public String toString() {
                return "clear";
            }
        }
        ,
        RAIN{

            public String toString() {
                return "storm";
            }
        }
        ,
        THUNDER{

            public String toString() {
                return "thunder";
            }
        }
        ,
        RESET{

            public String toString() {
                return "reset";
            }
        }
        ,
        UNKNOWN{

            public String toString() {
                return "Unknown";
            }
        };

    }

    public static enum Time {
        DAY,
        MIDDAY,
        EVENING,
        SUNSET,
        NIGHT,
        MIDNIGHT,
        RESET,
        SUNRISE;

    }
}

