/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.stats;

import java.util.Objects;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.Logger;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandSpeed
extends FoundryCommand {
    private final Essence plugin;

    public CommandSpeed(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.stats.speed";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage message = new UtilMessage(this.plugin, cs);
        if (args.length == 1) {
            if (cs instanceof Player) {
                Player p = (Player)cs;
                return this.speedSelf(p, message, args);
            }
            message.send("speed", "usage");
            return true;
        }
        if (args.length == 2) {
            return this.speedOther(new UtilPermission(this.plugin, cs), cs, message, args);
        }
        if (cs instanceof Player) {
            Player p = (Player)cs;
            message.send("speed", "current", new String[]{String.valueOf(p.getWalkSpeed() * 10.0f)});
        } else {
            message.send("speed", "usage");
        }
        return true;
    }

    private boolean speedSelf(Player p, UtilMessage msg, String[] args) {
        try {
            if (Objects.equals(args[0], "off") || Objects.equals(args[0], "reset")) {
                p.setWalkSpeed(0.2f);
                p.setFlySpeed(0.1f);
                msg.send("speed", "reset");
            } else {
                float speed = Float.parseFloat(args[0]);
                if (speed > 10.0f || speed < -10.0f) {
                    msg.send("speed", "bounds");
                    return true;
                }
                p.setWalkSpeed(speed / 10.0f);
                p.setFlySpeed(speed / 10.0f);
                msg.send("speed", "set", new String[]{args[0]});
            }
        }
        catch (NullPointerException | NumberFormatException e) {
            msg.send("speed", "usage");
            msg.send("generic", "exception");
            new Logger(this.plugin.foundryConfig).severe("Unable to set player speed due to error:");
            new Logger(this.plugin.foundryConfig).severe(e.getMessage());
        }
        return true;
    }

    private boolean speedOther(UtilPermission perms, CommandSender cs, UtilMessage msg, String[] args) {
        if (perms.has("essence.stats.speed.other")) {
            Player p = Bukkit.getPlayer((String)args[1]);
            if (p != null) {
                try {
                    if (Objects.equals(args[0], "off") || Objects.equals(args[0], "reset")) {
                        p.setWalkSpeed(0.2f);
                        p.setFlySpeed(0.1f);
                        msg.send("speed", "resetbyother", new String[]{cs.getName()});
                        msg.sendTo(cs, "speed", "resetother");
                    } else {
                        float speed = Float.parseFloat(args[0]);
                        if (speed > 10.0f || speed < -10.0f) {
                            msg.send("speed", "bounds");
                            return true;
                        }
                        p.setWalkSpeed(speed / 10.0f);
                        p.setFlySpeed(speed / 10.0f);
                        msg.send("speed", "setbyother", new String[]{cs.getName(), args[0]});
                        msg.sendTo(cs, "speed", "setother", new String[]{args[1], args[0]});
                    }
                }
                catch (NullPointerException | NumberFormatException e) {
                    msg.send("speed", "usage");
                    msg.send("generic", "exception");
                    new Logger(this.plugin.foundryConfig).severe("Unable to set player speed due to error:");
                    new Logger(this.plugin.foundryConfig).severe(e.getMessage());
                }
                return true;
            }
            msg.send("generic", "playernotfound");
            return true;
        }
        return perms.not();
    }
}

