/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.team;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Security;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class UtilTeam {
    private final Essence plugin;
    private final UtilMessage message;

    public UtilTeam(Essence plugin, UtilMessage message) {
        this.plugin = plugin;
        this.message = message;
    }

    public void create(String name, UUID leader) {
        Files teamsFile;
        if (new Security(this.plugin.foundryConfig).hasSpecialCharacters(name)) {
            this.message.send("team", "specialchars");
            return;
        }
        if (name.length() > 12) {
            this.message.send("team", "longname");
        }
        if (!(teamsFile = new Files(this.plugin.foundryConfig, this.plugin)).exists("data/teams/" + name + ".yml")) {
            if (teamsFile.create("data/teams/" + name + ".yml")) {
                teamsFile.load("data/teams/" + name + ".yml");
                teamsFile.set("members.leader", leader.toString());
                teamsFile.set("members.default", null);
                teamsFile.set("rules.allow-friendly-fire", true);
                teamsFile.set("rules.allow-team-homes", true);
                teamsFile.save();
                UtilPlayer up = new UtilPlayer(this.plugin);
                up.setPlayer(leader, UtilPlayer.KEYS.USER_TEAM, name);
                up.savePlayer(leader);
                this.message.send("team", "created", new String[]{name});
            } else {
                this.message.send("generic", "exception");
                this.plugin.log.warn("Unable to create new team file at 'data/teams/" + name + ".yml' - is this file writeable?");
            }
        } else {
            this.message.send("team", "exists");
        }
    }

    public void requestJoin(String team, UUID player) {
        Files teamsFile = new Files(this.plugin.foundryConfig, this.plugin);
        if (teamsFile.exists("data/teams/" + team + ".yml")) {
            teamsFile.load("data/teams/" + team + ".yml");
            List<String> requests = teamsFile.getStringList("members.requests");
            requests.add(player.toString());
            teamsFile.set("members.requests", requests);
            teamsFile.save();
            this.message.send("team", "requested", new String[]{team});
        } else {
            this.message.send("team", "notfound");
        }
    }

    public String requestsToJoin(String team) {
        Files teamsFile = new Files(this.plugin.foundryConfig, this.plugin);
        if (teamsFile.exists("data/teams/" + team + ".yml")) {
            teamsFile.load("data/teams/" + team + ".yml");
            List<String> requests = teamsFile.getStringList("members.requests");
            teamsFile.close();
            StringBuilder requestList = new StringBuilder();
            int i = 0;
            for (String key : requests) {
                Files playerFile = new Files(this.plugin.foundryConfig, this.plugin);
                playerFile.load(playerFile.playerDataFile(UUID.fromString(key)));
                if (i == 0) {
                    requestList.append(playerFile.getString("user.last-known-name"));
                } else {
                    requestList.append(", ").append(playerFile.getString("user.last-known-name"));
                }
                playerFile.close();
                ++i;
            }
            return requestList.toString();
        }
        this.message.send("team", "notfound");
        return "";
    }

    public boolean isLeader(String team, UUID player) {
        Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
        if (teamData.exists("data/teams/" + team + ".yml")) {
            teamData.load("data/teams/" + team + ".yml");
            String leader = teamData.getString("members.leader");
            teamData.close();
            return leader.equalsIgnoreCase(player.toString());
        }
        return false;
    }

    @Nullable
    public String getPlayerTeam(UUID player) {
        Object team = new UtilPlayer(this.plugin).getPlayer(player, UtilPlayer.KEYS.USER_TEAM);
        if (team == null) {
            return null;
        }
        return team.toString();
    }

    public boolean acceptRequest(String team, String player) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)player);
        new UtilPlayer(this.plugin).setPlayer(op.getUniqueId(), UtilPlayer.KEYS.USER_TEAM, team);
        Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
        teamData.load("data/teams/" + team + ".yml");
        List<String> defaultMembers = teamData.getStringList("members.default");
        defaultMembers.add(String.valueOf(op.getUniqueId()));
        teamData.set("members.default", defaultMembers);
        List<String> requestedMembers = teamData.getStringList("members.requests");
        requestedMembers.remove(String.valueOf(op.getUniqueId()));
        teamData.set("members.requests", requestedMembers);
        teamData.save();
        return true;
    }

    public boolean declineRequest(String team, String player) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)player);
        Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
        teamData.load("data/teams/" + team + ".yml");
        List<String> requestedMembers = teamData.getStringList("members.requests");
        requestedMembers.remove(String.valueOf(op.getUniqueId()));
        teamData.set("members.requests", requestedMembers);
        teamData.save();
        return true;
    }

    public boolean leave(String playerTeam, UUID uuid) {
        UtilPlayer up = new UtilPlayer(this.plugin);
        if (up.getPlayer(uuid, UtilPlayer.KEYS.USER_TEAM) != null) {
            up.setPlayer(uuid, UtilPlayer.KEYS.USER_TEAM, null);
        }
        Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
        teamData.load("data/teams/" + playerTeam + ".yml");
        List<String> defaultMembers = teamData.getStringList("members.default");
        defaultMembers.remove(String.valueOf(uuid));
        teamData.set("members.default", defaultMembers);
        return true;
    }

    public boolean changeLeader(String playerTeam, String newLeader, String oldLeader) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)newLeader);
        Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
        teamData.load("data/teams/" + playerTeam + ".yml");
        teamData.set("members.leader", String.valueOf(op.getUniqueId()));
        List<String> defaultMembers = teamData.getStringList("members.default");
        defaultMembers.add(oldLeader);
        defaultMembers.remove(String.valueOf(op.getUniqueId()));
        teamData.set("members.default", defaultMembers);
        teamData.save();
        return true;
    }

    public String getTeamLeader(String team) {
        if (team != null) {
            Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
            teamData.load("data/teams/" + team + ".yml");
            String leader = teamData.getString("members.leader");
            teamData.close();
            if (leader != null) {
                Files playerData = new Files(this.plugin.foundryConfig, this.plugin);
                playerData.load(playerData.playerDataFile(UUID.fromString(leader)));
                leader = playerData.getString("user.last-known-name");
                playerData.close();
                return leader;
            }
            return null;
        }
        return null;
    }

    public String getTeamMembers(String team) {
        Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
        teamData.load("data/teams/" + team + ".yml");
        List<String> requests = teamData.getStringList("members.default");
        teamData.close();
        StringBuilder membersList = new StringBuilder();
        int i = 0;
        for (String key : requests) {
            Files playerDataFile = new Files(this.plugin.foundryConfig, this.plugin);
            playerDataFile.load(playerDataFile.playerDataFile(UUID.fromString(key)));
            if (i == 0) {
                membersList.append(playerDataFile.getString("user.last-known-name"));
            } else {
                membersList.append(", ").append(playerDataFile.getString("user.last-known-name"));
            }
            playerDataFile.close();
            ++i;
        }
        return membersList.toString();
    }

    public boolean kick(String playerTeam, String playerToKick) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)playerToKick);
        return this.leave(playerTeam, op.getUniqueId());
    }

    public boolean isMember(String team, String username) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)username);
        String uuid = op.getUniqueId().toString();
        Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
        teamData.load("data/teams/" + team + ".yml");
        List<String> members = teamData.getStringList("members.default");
        teamData.close();
        for (String key : members) {
            if (!Objects.equals(key, uuid)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRequested(String team, String username) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)username);
        String uuid = op.getUniqueId().toString();
        Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
        teamData.load("data/teams/" + team + ".yml");
        List<String> members = teamData.getStringList("members.requests");
        teamData.close();
        for (String key : members) {
            if (!Objects.equals(key, uuid)) continue;
            return true;
        }
        return false;
    }

    public boolean disband(String team, String teamLeader) {
        Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
        teamData.load("data/teams/" + team + ".yml");
        List<String> members = teamData.getStringList("members.default");
        teamData.close();
        for (String key : members) {
            Files playerData = new Files(this.plugin.foundryConfig, this.plugin);
            playerData.load(playerData.playerDataFile(UUID.fromString(key)));
            playerData.set("user.team", null);
            playerData.save();
        }
        Files playerData = new Files(this.plugin.foundryConfig, this.plugin);
        playerData.load(playerData.playerDataFile(UUID.fromString(teamLeader)));
        playerData.set("user.team", null);
        playerData.save();
        return teamData.delete("data/teams/" + team + ".yml");
    }

    public boolean areTeammates(Player p1, Player p2) {
        Files p1data = new Files(this.plugin.foundryConfig, this.plugin);
        p1data.load(p1data.playerDataFile(p1));
        if (p1data.getString("user.team") == null) {
            return false;
        }
        String p1team = p1data.getString("user.team");
        p1data.close();
        Files p2data = new Files(this.plugin.foundryConfig, this.plugin);
        p2data.load(p2data.playerDataFile(p2));
        if (p2data.getString("user.team") == null) {
            return false;
        }
        String p2team = p2data.getString("user.team");
        p2data.close();
        return p1team.equalsIgnoreCase(p2team);
    }

    public boolean getRule(String team, String rule) {
        Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
        teamData.load("data/teams/" + team + ".yml");
        boolean result = teamData.getBoolean("rules." + rule);
        teamData.save();
        return result;
    }

    public boolean setRule(String team, String rule, boolean value) {
        Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
        teamData.load("data/teams/" + team + ".yml");
        teamData.set("rules." + rule, value);
        teamData.save();
        return true;
    }

    public boolean exists(String team) {
        Files teamData = new Files(this.plugin.foundryConfig, this.plugin);
        return teamData.exists("data/teams/" + team + ".yml");
    }

    public String getTeamPrefix(CommandSender cs) {
        if (cs instanceof Player) {
            Player p = (Player)cs;
            String prefix = this.getPlayerTeam(p.getUniqueId());
            if (prefix == null) {
                return "";
            }
            return "[" + prefix + "]";
        }
        return "";
    }
}

