/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.command.FoundryCommand;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandBottom
extends FoundryCommand {
    private final Essence plugin;

    public CommandBottom(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.teleport.bottom";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        if (args.length == 0) {
            if (!(cs instanceof Player)) {
                msg.send("bottom", "usage");
                return true;
            }
            return this.bottomSelf((Player)cs, msg);
        }
        if (args.length == 1) {
            UtilPermission perms = new UtilPermission(this.plugin, cs);
            if (!perms.has("essence.teleport.other")) {
                return perms.not();
            }
            return this.bottomOther(cs, msg, args[0]);
        }
        msg.send("bottom", "usage");
        return true;
    }

    private boolean bottom(Player player, UtilMessage msg, CommandSender sender, boolean isSelf) {
        int waitTime;
        Location safeLocation = UtilTeleport.findFurthestLocation(player.getLocation(), UtilTeleport.Direction.DOWN, player);
        int n = waitTime = this.plugin.config.get("teleportation.bottom.wait") != null ? (Integer)this.plugin.config.get("teleportation.bottom.wait") : 0;
        if (safeLocation == null) {
            msg.send("bottom", "nosafelocation");
            return true;
        }
        if (player.getLocation().getBlockY() <= safeLocation.getBlockY()) {
            if (isSelf) {
                msg.send("bottom", "alreadyatbottom");
            } else {
                msg.send("bottom", "alreadyatbottomother", new String[]{player.getName()});
            }
            return true;
        }
        new UtilTeleport(this.plugin).doTeleport(player, safeLocation, waitTime, true);
        if (waitTime == 0) {
            if (isSelf) {
                msg.send("bottom", "going");
            } else {
                msg.send("bottom", "goingother", new String[]{player.getName()});
                new UtilMessage(this.plugin, (CommandSender)player).send("bottom", "sentby", new String[]{sender.getName()});
            }
        }
        return true;
    }

    private boolean bottomSelf(Player p, UtilMessage msg) {
        return this.bottom(p, msg, (CommandSender)p, true);
    }

    private boolean bottomOther(CommandSender cs, UtilMessage msg, String targetName) {
        Player targetPlayer = Bukkit.getPlayer((String)targetName);
        if (targetPlayer == null) {
            msg.send("generic", "playernotfound");
            return true;
        }
        return this.bottom(targetPlayer, msg, cs, false);
    }
}

